% Supplementary materials of the article
%
% Raze, G., Jadoul, A., Guichaux, S., Broun, V. and Kerschen, G., 2019. 
% A digital nonlinear piezoelectric tuned vibration absorber. 
% Smart Materials and Structures, 29(1), p.015007.
% doi: 10.1088/1361-665X/ab5176
% https://hdl.handle.net/2268/242115
%
% Plot the FRFs of a short-circuited, open-circuited and shunted sdof
% piezoelectric structure (Figure 2)

load('SystemParameters')

Kc = sqrt((koc-ksc)/ksc);
omoc = sqrt(koc/m);

sysoc = tf(1,[m,c,koc]);
syssc = tf(1,[m,c,ksc]);
sysSh = 1/(tf([m,c,koc],1)-tf(theta^2,[L,R,1/Cpe]));
omV = 2*pi*linspace(20,40,1000);

figure
hold on
plot(omV/2/pi,squeeze(abs(freqresp(syssc,omV))),'-k','linewidth',2)
plot(omV/2/pi,squeeze(abs(freqresp(sysoc,omV))),'-','linewidth',2,'color',[0.4 0.4 0.4])
plot(omV/2/pi,squeeze(abs(freqresp(sysSh,omV))),'-b','linewidth',2)
xlim([20 40])
ylim([0 2e-3])
ylabel('|x/f| (m/N)')
xlabel('Frequency (Hz)')
box on
set(gca,'fontsize',16)
