% Finite difference derivation
% 
% Input: 
%   * x, y: vectors of the same length
% Output
%   * dy = d(y(x))/dx, approximated by finite differences (first and last
%   elements by forward and backward FD, and other elements by centered FD)
%
function dy = finiteDerivation(x,y)

  dy = zeros(size(y));
  dy(1) = (y(2)-y(1))/(x(2)-x(1));
  dy(end) = (y(end)-y(end-1))/(x(end)-x(end-1));
  
  dy(2:end-1) = (y(3:end)-y(1:end-2))./(x(3:end)-x(1:end-2));
end

