% Supplementary materials of the article
%
% Raze, G., Jadoul, A., Guichaux, S., Broun, V. and Kerschen, G., 2019. 
% A digital nonlinear piezoelectric tuned vibration absorber. 
% Smart Materials and Structures, 29(1), p.015007.
% doi: 10.1088/1361-665X/ab5176
% https://hdl.handle.net/2268/242115
%
% This study presents the practical realization of a digital vibration
% absorber that, owing to the flexibility provided by the digital unit,
% synthesizes linear and nonlinear shunt circuits. The absorber, composed
% of a microprocessor and a current source, is connected to the host
% structure with piezoelectric patches. The performance of both circuits is
% compared experimentally for a nonlinear host structure. The superiority
% of a properly-tuned nonlinear absorber over its linear counterpart is
% validated, but the limits of the nonlinear absorber are also explored.
% Moreover, the accuracy of the tuning procedure and formulas is assessed
% through experimental parametric studies.
%
%
% 
% The experimental data associated with this work is gathered in the Data/
% folder, with subfolders
%   * Uncontrolled/ containing data about the bare beam (FRFs and time
%   series)
%   * L/ containing data about the beam controlled by an LPTVA (FRFs)
%   * NL/ containing data about the beam controlled by an NPTVA (FRFs and
%   figure files with data from Simulink run on an Arduino due)
%   * PoS/ containing data about the NPTVA with quadratic and quintic
%   nonlinear capacitance (FRFs)
%   * Parametric/ containing data about a parametric study of the NPTVA on
%   the inductance, resistance and nonlinear capacitance
% 
% In these files, the forcing level is generally indicated in the file name
% (e.g. 0-2N means that the forcing level was 0.2N)
% 'FRF' idicates that the file contains an FRF, whereas '_a' and '_f'
% indicate a time series of the acceleration and force, respectively.
%
%
%
% The associated Matlab code consists in scripts:
%   * uncontrolledNFR: Plot the linear and nonlinear (at a forcing of 0.2N)
%   FRFs of the uncontrolled beam
%   * computeSystemParameters: Compute the parameters of the uncontrolled
%   systems (Table 1)  and the NPTVA parameters (Table 2)
%   * linear_FRF: Plot the FRFs of a short-circuited, open-circuited and
%   shunted sdof piezoelectric structure (Figure 2)
%   * absorberParameters: Compute the DNPTVA parameters
%   * checkNLImpedance: Check the nonlinear impedance of the DNPTVA
%   (Figures 10-12 and 14)
%   * NFRFs: Plot the nonlinear 'FRFs' of the controlled system (Figures
%   13, 15 and 16)
%   * ArduinoSaturation: Plot the saturation of the DNPTVA (Figure 17)
%   * parametricStudy: Parametric study for the inductance, resistance and
%   nonlinear capacitance (Figures 20-23)
%   * principleOfSimilarity: Test the principle of similarity with
%   quadratic and quintic nonlinear capacitance in the NPTVA (Figures 18
%   and 19)
% The code requires the Optimization Toolbox and the Control System Toolbox
% to be fully functional.
%
%
%
% More data can be made available on request to Ghislain Raze at
% g.raze@uliege.be