% Supplementary materials of the article
%
% Raze, G., Jadoul, A., Guichaux, S., Broun, V. and Kerschen, G., 2019. 
% A digital nonlinear piezoelectric tuned vibration absorber. 
% Smart Materials and Structures, 29(1), p.015007.
% doi: 10.1088/1361-665X/ab5176
% https://hdl.handle.net/2268/242115
%
% Compute the DNPTVA parameters

load('SystemParameters');

% Board parameters
Ts = 1e-4;
Vp = 148;
VADC = 1.614;
Ri = 152.9;

% Gains
alpha = VADC/Vp;
g = Ri/alpha;
gnl = 1.7*Cnl*alpha/(Ri^3);     % The factor 1.7 is heuristically used to compensate for the piezo NL

% Shunt transfer function
H = tf(g,[L,R]);
Hds = c2d(H,Ts,'Tustin');
[numds,dends] = tfdata(Hds,'v');
if numds(1) == 0
  numds = numds(2:end);
end

% ADC and DAC characteristics
VinMax = 0.5*(3.3-0);       % Maximum MCU input amplitude (V)
VoutMax = 0.5*(2.75-0.55);  % Maximum MCU output amplitude (V)

Nin = 12;                   % Number of input bits (-)
Cin = 2*VinMax/(2^Nin-1);   % Integer-to-input-voltage conversion ratio (V)
Din = 2^(Nin-1);            % Input offset (-)

Nout = 12;                  % Number of output bits (-)
Cout = (2^Nout-1)/(2*VoutMax);  % Output-voltage-to-integer conversion ratio (V^-1)
Dout = 2^(Nout-1);          % Output offset (-)


% LP filter characteristics
fbp = 1;        % Bandpass filter cut-off frequency 1
fbp2 = 0.5;     % Bandpass filter cut-off frequency 2
Hbp = tf(nthroot(gnl,3),[1,2*pi*fbp])*tf([1,0],[1,2*pi*fbp2]);
Hbpd = c2d(Hbp,Ts);    % NB: Tustin creates an algebraic loop
[numbp,denbp] = tfdata(Hbpd,'v');
if numbp(1) == 0
  numbp = numbp(2:end);
end
