% Supplementary materials of the article
%
% Raze, G., Jadoul, A., Guichaux, S., Broun, V. and Kerschen, G., 2019. 
% A digital nonlinear piezoelectric tuned vibration absorber. 
% Smart Materials and Structures, 29(1), p.015007.
% doi: 10.1088/1361-665X/ab5176
% https://hdl.handle.net/2268/242115
%
% Plot the saturation of the DNPTVA (Figure 17)

% Data
[t,Vin,Vout,VNL] = ArduinoData('.\Data\NL\NL_1-2N_coeff1-8.fig');
t = t-t(1);

% Plot
figure
hold on
plot(t(1:2:end),Vin(1:2:end),'-b')
plot(t(1:2:end),Vout(1:2:end),'-r')
plot([t(1),t(end)],[1.65,1.65],'-.','Color',[0 0 0.4],'linewidth',2)
plot([t(1),t(end)],-[1.65,1.65],'-.','Color',[0 0 0.4],'linewidth',2)
plot([t(1),t(end)],[1.1,1.1],'-.','Color',[0.4 0 0],'linewidth',2)
plot([t(1),t(end)],-[1.1,1.1],'-.','Color',[0.4 0 0],'linewidth',2)
xlim([t(1),t(end)])
ylim([-2,2])
box on
xlabel('Time (s)')
ylabel('Voltage (V)')
set(gca,'fontsize',16)