function [Nodes, Elements, NNode, NElem, SUPP, SBCR] = NodesElements(LLS, LRS, LMS, H, SH, NdivSH, NdivH, HM, SideCables, SideHangers)
%% Node numbers

LTOT = LLS + LRS + LMS; % m - Total length of the bridge

LdivSH = SH/NdivSH; % m - X-Length of elements between hangers
LdivH = H/NdivH; % m - X-Length of elements between hangers

NT = LTOT/LdivSH; % Number of elements in cable or beam
NL = LLS/LdivSH; % Number of elements in left cable
NM = LMS/LdivSH; % Number of elements in main cable
NR = LRS/LdivSH; % Number of elements in right cable

% Beam

j = 0;

SBCL = 1; j = SBCL; % Node shared between beam and left cable

BBL = j + 1; j = BBL;  % First node of left beam
FBL = j + NL - 2; j = FBL; % Final node of left beam

SBP1 = j + 1; j = SBP1; % Node shared between beam and first tower

BBM = j + 1; j = BBM; % First node of main beam
FBM = j + NM - 2; j = FBM; % Final node of main beam

SBP2 = j + 1; j = SBP2; % Node shared between beam and second tower

BBR = j + 1; j = BBR; % First node of right beam
FBR = j + NR - 2; j = FBR; % Final node of right beam

SBCR = j + 1; j = SBCR; % Node shared between beam and right cable

% Cable

BCL = j + 1; j = BCL; % First node of left cable
FCL = j + NL - 2; j = FCL; % Final node of left cable

SCP1 = j + 1; j = SCP1; % Node shared between first tower and cable

BCM = j + 1; j = BCM; % First node of main cable
FCM = j + NM - 2; j = FCM; % Final node of main cable

SCP2 = j + 1; j = SCP2; % Node shared between second tower and cable

BCR = j + 1; j = BCR; % First node of main cable
FCR = j + NR - 2; j = FCR; % Final node of main cable

% Towers

NP = H/LdivH; % Number of elements in the towers

BP1 = j + 1; j = BP1; % First node of the left tower
FP1 = j + NP - 2; j = FP1; % Last node of the left tower

BP2 = j + 1; j = BP2; % First node of the right tower
FP2 = j + NP - 2; j = FP2; % Last node of the right tower

%% Node coordinates

% Beam

for i = SBCL:SBCR
    XNOD(i) = (i-SBCL)*LdivSH;
    YNOD(i) = 0;
    NODENAM(i) = i;  
end

% Left cable

syms al bl cl

eq1l = 0 == al*(0)^2 + bl*(0) + cl;
eq2l = H == al*(LLS)^2 + bl*(LLS) + cl;
eq3l = 0 == 2*al*(0) + bl;

S = solve([eq1l, eq2l, eq3l],[al, bl, cl]);
al = double(S.al);
bl = double(S.bl);
cl = double(S.cl);

if SideCables == 1

for i = BCL:FCL
    XNOD(i) = (i-BCL+1)*LdivSH;
    YNOD(i) = al * XNOD(i)^2 + bl * XNOD(i) + cl;
    NODENAM(i) = i;
end

elseif SideCables == 2
for i = BCL:FCL
    XNOD(i) = (i-BCL+1)*LdivSH;
    YNOD(i) = (XNOD(i)-XNOD(SBCL))/LLS*H;
    NODENAM(i) = i;
end

end

XNOD(SCP1) = LLS;
YNOD(SCP1) = H;
NODENAM(SCP1) = SCP1;

% Main cable

syms vam vbm vcm

eq1m = H == vam*LLS^2 + vbm*LLS + vcm;
eq2m = HM == vam*(LLS+LMS/2)^2 + vbm*(LLS+LMS/2) + vcm;
eq3m = 0 == 2*vam*(LLS+LMS/2) + vbm;

S = solve([eq1m, eq2m, eq3m],[vam, vbm, vcm]);
am = double(S.vam);
bm = double(S.vbm);
cm = double(S.vcm);

for i = BCM:FCM
    XNOD(i) = LLS+(i-BCM+1)*LdivSH;
    YNOD(i) = am * XNOD(i)^2 + bm * XNOD(i) + cm;
    NODENAM(i) = i;
end

XNOD(SCP2) = LLS + LMS;
YNOD(SCP2) = H;
NODENAM(SCP2) = SCP2;

% Right cable

syms vvar vbr vcr

eq1r = H == vvar*(LLS+LMS)^2 + vbr*(LLS+LMS) + vcr;
eq2r = 0 == vvar*(LTOT)^2 + vbr*(LTOT) + vcr;
eq3r = 0 == 2*vvar*(LTOT) + vbr;

S = solve([eq1r, eq2r, eq3r],[vvar, vbr, vcr]);
ar = double(S.vvar);
br = double(S.vbr);
cr = double(S.vcr);

if SideCables == 1
    
for i = BCR:FCR
    XNOD(i) = (i-BCL+1)*LdivSH;
    YNOD(i) = ar * XNOD(i)^2 + br * XNOD(i) + cr;
    NODENAM(i) = i;
end  

elseif SideCables == 2
    
for i = BCR:FCR
    XNOD(i) = (i-BCL+1)*LdivSH;
    YNOD(i) = H*(1-(XNOD(i)-XNOD(SBP2))/LRS);
    NODENAM(i) = i;
end 

end

% Pylons

for i = BP1:FP1
    XNOD(i) = (SBP1-1)*LdivSH;
    YNOD(i) = (i-BP1+1)*LdivH;
    NODENAM(i) = i;
end      

for i = BP2:FP2
    XNOD(i) = (SBP2-1)*LdivSH;
    YNOD(i) = (i-BP2+1)*LdivH;
    NODENAM(i) = i;
end   

Nodes.XNOD = XNOD;
Nodes.YNOD = YNOD;
Nodes.NODENAM = NODENAM;
NNode = length(XNOD);

%% Supports

SUPP = [SBCL 1; SBCL 2; SBP1 1; SBP1 2; SBP2 1; SBP2 2; SBCR 1; SBCR 2];

%% Elements

j = 1;

% Beam

for i = SBCL:SBCR-1
    ELEMNOA(j) = i;
    ELEMNOB(j) = i+1;
    ELEMGEO(j) = 1;
    ELEMMAT(j) = 1;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Beam";
    ELEMN(j) = 0;
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    j = j + 1;
end

% Cable

NHOR = 800e6;

ELEMNOA(j) = SBCL;
ELEMNOB(j) = BCL;
ELEMGEO(j) = 2;
ELEMMAT(j) = 2;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Cable";
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
ELEMN(j) = NHOR/ELEMCOS(j);
j = j + 1;

for i = BCL:FCL-1
    ELEMNOA(j) = i;
    ELEMNOB(j) = i+1;
    ELEMGEO(j) = 2;
    ELEMMAT(j) = 2;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Cable";
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    ELEMN(j) = NHOR/ELEMCOS(j);
    j = j + 1;
end

ELEMNOA(j) = FCL;
ELEMNOB(j) = SCP1;
ELEMGEO(j) = 2;
ELEMMAT(j) = 2;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Cable";
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
ELEMN(j) = NHOR/ELEMCOS(j);
j = j + 1;

ELEMNOA(j) = SCP1;
ELEMNOB(j) = BCM;
ELEMGEO(j) = 2;
ELEMMAT(j) = 2;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Cable";
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
ELEMN(j) = NHOR/ELEMCOS(j);
j = j + 1;

for i = BCM:FCM-1
    ELEMNOA(j) = i;
    ELEMNOB(j) = i+1;
    ELEMGEO(j) = 2;
    ELEMMAT(j) = 2;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Cable";
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    ELEMN(j) = NHOR/ELEMCOS(j);
    j = j + 1;
end

ELEMNOA(j) = FCM;
ELEMNOB(j) = SCP2;
ELEMGEO(j) = 2;
ELEMMAT(j) = 2;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Cable";
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
ELEMN(j) = NHOR/ELEMCOS(j);
j = j + 1;

ELEMNOA(j) = SCP2;
ELEMNOB(j) = BCR;
ELEMGEO(j) = 2;
ELEMMAT(j) = 2;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Cable";
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
ELEMN(j) = NHOR/ELEMCOS(j);
j = j + 1;

for i = BCR:FCR-1
    ELEMNOA(j) = i;
    ELEMNOB(j) = i+1;
    ELEMGEO(j) = 2;
    ELEMMAT(j) = 2;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Cable";
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    ELEMN(j) = NHOR/ELEMCOS(j);
    j = j + 1;
end

ELEMNOA(j) = FCR;
ELEMNOB(j) = SBCR;
ELEMGEO(j) = 2;
ELEMMAT(j) = 2;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Cable";
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
ELEMN(j) = NHOR/ELEMCOS(j);
j = j + 1;

% Pylon 1

ELEMNOA(j) = SBP1;
ELEMNOB(j) = BP1;
ELEMGEO(j) = 3;
ELEMMAT(j) = 4;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Tower";
ELEMN(j) = 0;
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
j = j + 1;

for i = BP1:FP1-1
    ELEMNOA(j) = i;
    ELEMNOB(j) = i+1;
    ELEMGEO(j) = 3;
    ELEMMAT(j) = 4;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Tower";
    ELEMN(j) = 0;
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    j = j + 1;
end

ELEMNOA(j) = FP1;
ELEMNOB(j) = SCP1;
ELEMGEO(j) = 3;
ELEMMAT(j) = 4;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Tower";
ELEMN(j) = 0;
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
j = j + 1;

% Pylon 2

ELEMNOA(j) = SBP2;
ELEMNOB(j) = BP2;
ELEMGEO(j) = 3;
ELEMMAT(j) = 4;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Tower";
ELEMN(j) = 0;
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
j = j + 1;

for i = BP2:FP2-1
    ELEMNOA(j) = i;
    ELEMNOB(j) = i+1;
    ELEMGEO(j) = 3;
    ELEMMAT(j) = 4;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Tower";
    ELEMN(j) = 0;
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    j = j + 1;
end

ELEMNOA(j) = FP2;
ELEMNOB(j) = SCP2;
ELEMGEO(j) = 3;
ELEMMAT(j) = 4;
ELEMTYP(j) = 1;
ELEMNAM(j) = "Tower";
ELEMN(j) = 0;
ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
j = j + 1;

% Hangers

if SideHangers == 1
for i = NdivSH:NdivSH:(FBL-BBL+1)
    ELEMNOA(j) = BBL+i-1;
    ELEMNOB(j) = BCL+i-1;
    ELEMGEO(j) = 4;
    ELEMMAT(j) = 3;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Hanger";
    ELEMN(j) = 0;
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    j = j + 1;
end
end

for i = NdivSH:NdivSH:(FBM-BBM+1)
    ELEMNOA(j) = BBM+i-1;
    ELEMNOB(j) = BCM+i-1;
    ELEMGEO(j) = 4;
    ELEMMAT(j) = 3;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Hanger";
    ELEMN(j) = 0;
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    j = j + 1;
end

if SideHangers == 1
for i = NdivSH:NdivSH:(FBR-BBR)
    ELEMNOA(j) = BBR+i-1;
    ELEMNOB(j) = BCR+i-1;
    ELEMGEO(j) = 4;
    ELEMMAT(j) = 3;
    ELEMTYP(j) = 1;
    ELEMNAM(j) = "Hanger";
    ELEMN(j) = 0;
    ELEMLEN(j) = norm([diff(XNOD([ELEMNOA(j) ELEMNOB(j)])); diff(YNOD([ELEMNOA(j) ELEMNOB(j)]))]);
    ELEMCOS(j) = (XNOD(ELEMNOB(j))-XNOD(ELEMNOA(j))) / ELEMLEN(j);
    j = j + 1;
end
end

Elements.ELEMNOA = ELEMNOA;
Elements.ELEMNOB = ELEMNOB;
Elements.ELEMGEO = ELEMGEO;
Elements.ELEMMAT = ELEMMAT;
Elements.ELEMTYP = ELEMTYP;
Elements.ELEMNAM = ELEMNAM;
Elements.ELEMN = ELEMN;
Elements.ELEMLEN = ELEMLEN;
Elements.ELEMCOS = ELEMCOS;
Elements.ELEMSP1 = zeros(length(ELEMLEN),1);
Elements.ELEMSP2 = zeros(length(ELEMLEN),1);
NElem = length(ELEMNOA);
end

