function [Materials, Geometries] = MatGeom
% MATGEOM Creates matrices which contains
% Materials' Name, Young Modulus, Density
% Geometries' Name, Area, Inertia

Materials(1).Name = "Steel"; % Name of material
Materials(1).Young = 2.1e11; % Young modulus [N/m^2]
Materials(1).Density = 15000/1; % Material density [kg/m^3]

Materials(2).Name = "Cable"; % Name of material
Materials(2).Young = 2.1e11; % Young modulus [kN/m^2]
Materials(2).Density = 7000/0.8; % Material density [kg/m^3]

Materials(3).Name = "Hanger"; % Name of material
Materials(3).Young = 2.1e11; % Young modulus [kN/m^2]
Materials(3).Density = 7000/0.05; % Material density [kg/m^3]

Materials(4).Name = "Concrete"; % Name of material
Materials(4).Young = 0.4e11; % Young modulus [N/m^2]
Materials(4).Density = 180000/60; % Material density [kg/m^3]

Geometries(1).Name = "Beam"; % Name of geometry
Geometries(1).A = 1; % Cross-section [m^2]
Geometries(1).I = 3.32; % Second moment of inertia [m^4]

Geometries(2).Name = "Cable"; % Name of geometry
Geometries(2).A = 0.8; % Cross-section [m^2]
Geometries(2).I = 0; % Second moment of inertia [m^4]

Geometries(3).Name = "Tower"; % Name of geometry
Geometries(3).A = 60; % Cross-section [m^2]
Geometries(3).I = 400; % Second moment of inertia [m^4]

Geometries(4).Name = "Hanger"; % Name of geometry
Geometries(4).A = 0.05; % Cross-section [m^2]
Geometries(4).I = 0; % Second moment of inertia [m^4]

end

