function [KGapp,Mapp,Elements, CORRES] = Assemble(NNode,NElem,Nodes,Elements,Geometries,Materials, SUPP)
%
% Boucle sur les lments de la structure et assemble les matrices de
% raideur et de masse lmentaire
%
% SEE ALSO : RaideurBeam3, MasseBeam3 pour les expressions des matrices lmentaires

NDOF =3*NNode; % 3 DDL par noeud

XNOD = Nodes.XNOD;
YNOD = Nodes.YNOD;

ELEMGEO = Elements.ELEMGEO;
ELEMMAT = Elements.ELEMMAT;
ELEMNOA = Elements.ELEMNOA;
ELEMNOB = Elements.ELEMNOB;
ELEMTYP = Elements.ELEMTYP;
ELEMN = Elements.ELEMN;

K=zeros(NDOF,NDOF); % Matrice de raideur structurelle
G=zeros(NDOF,NDOF); % Matrice de raideur gomtrique
M=zeros(NDOF,NDOF); % Matrice de masse structurelle

Re=zeros(6,6,NElem);
Ke=zeros(6,6,NElem);
Me=zeros(6,6,NElem);

ELEMLEN = zeros(1, NElem);
ELEMDOF = zeros(6, NElem);

for el=1:NElem
    
    L = norm([diff(XNOD([ELEMNOA(el) ELEMNOB(el)])); diff(YNOD([ELEMNOA(el) ELEMNOB(el)]))]);
    ELEMLEN(el) = L;
    SinA = (YNOD(ELEMNOB(el))-YNOD(ELEMNOA(el))) / L;
    CosA = (XNOD(ELEMNOB(el))-XNOD(ELEMNOA(el))) / L;
        
    if ELEMTYP(el) == 1  % Element de poutre  2 noeuds
        
        Igeo = ELEMGEO(el); Imat = ELEMMAT(el);
        A = Geometries(Igeo).A;
        I = Geometries(Igeo).I;
        E = Materials(Imat).Young;
        ro= Materials(Imat).Density;
        
        [Kel,Ks] = RaideurBeam3(E*A,E*I,L);       % Matrice de raideur lmentaire
        Mel      = MasseBeam3(ro*A,L);            % Matrice de masse lmentaire
        
        % Rotation
        ROT = [CosA -SinA 0; SinA CosA 0; 0 0 1]; ROT = [ROT zeros(3,3);zeros(3,3) ROT];
        Kel = ROT * Kel * ROT';
        Ks  = ROT * Ks  * ROT' * ELEMN(el);
        Mel = ROT * Mel * ROT';
        
        % Assemblage
        NDOF1 = 3*ELEMNOA(el) - 2;
        NDOF2 = 3*ELEMNOB(el) - 2;
        ELEMDOF(:,el) = [NDOF1:NDOF1+2 NDOF2:NDOF2+2];
        
        K(ELEMDOF(:,el),ELEMDOF(:,el)) = K(ELEMDOF(:,el),ELEMDOF(:,el)) + Kel;
        G(ELEMDOF(:,el),ELEMDOF(:,el)) = G(ELEMDOF(:,el),ELEMDOF(:,el)) + Ks;
        M(ELEMDOF(:,el),ELEMDOF(:,el)) = M(ELEMDOF(:,el),ELEMDOF(:,el)) + Mel;
        
        Ke(:,:,el)=Kel;
        Me(:,:,el)=Mel;
        Re(:,:,el)=ROT;
    end
end

Elements.ELEMLEN = ELEMLEN;
Elements.ELEMDOF = ELEMDOF;
FIXDOF = (SUPP(:,1)-1)*3+SUPP(:,2);
CORRES = [1:1:NDOF];
CORRES(FIXDOF) = [];
KG = K + G;
KGapp = KG(CORRES,CORRES);
Mapp = M(CORRES,CORRES);

end

function M=MasseBeam3(m,L,I_A)

% Forme la matrice de masse lmentaire K d'un lment de poutre  2
% noeuds et 3 ddl par noeud (dpl axial, dpl transversal, rotation)
%
% ELEMENT A 6 DEGRES DE LIBERTE
% ------------------------------
% m : masse linique
% L   : Longueur de l'lment
% I_A : rapport I/A (m^2), optionnel
%
%   DDL | Effort
%  -----+--------
%    1  | Noeud 1 : effort axial
%    2  | Noeud 1 : effort tranchant
%    3  | Noeud 1 : moment de flexion
%    4  | Noeud 2 : effort axial
%    5  | Noeud 2 : effort tranchant
%    6  | Noeud 2 : moment de flexion

V=m*L/420;
A=m*L/6;


M=[ 2*A      0        0      A       0       0     ;
    0     156*V    22*V*L    0     54*V    -13*V*L ;
    0     22*V*L  4*V*L^2    0    13*V*L  -3*V*L^2 ;
    A       0        0     2*A      0       0      ;
    0     54*V    13*V*L     0    156*V   -22*V*L  ;
    0   -13*V*L -3*V*L^2     0   -22*V*L  4*V*L^2  ];

if nargin >=3
    M2=[  0        0        0      0       0       0     ;
        0      6/5       L/10    0     -6/5    L/10    ;
        0      L/10  2*L^2/15    0     -L/10  -L^2/30  ;
        0       0        0       0      0       0      ;
        0     -6/5    -L/10      0      6/5   -L/10    ;
        0      L/10  -L^2/30     0     -L/10  2*L^2/15];
    M = M + M2*m/L*I_A;
end
end

function [K, Ks]=RaideurBeam3(EA,EI,L)

% Forme la matrice de raideur lmentaire K d'un lment de poutre  2
% noeuds et 3 ddl par noeud (dpl axial, dpl transversal, rotation)
%
% ELEMENT A 6 DEGRES DE LIBERTE
% ------------------------------
% EA : Raideur extensionnelle
% EI : Raideur flexionnelle
% L   : Longueur de l'lment
%
%   DDL | Effort
%  -----+--------
%    1  | Noeud 1 : effort axial
%    2  | Noeud 1 : effort tranchant
%    3  | Noeud 1 : moment de flexion
%    4  | Noeud 2 : effort axial
%    5  | Noeud 2 : effort tranchant
%    6  | Noeud 2 : moment de flexion

V=EI/L^3;
B=EA/L;

K=[ B       0      0      -B      0      0     ;
    0     12*V    6*V*L    0   -12*V   6*V*L   ;
    0    6*V*L  4*V*L^2    0   -6*V*L  2*V*L^2 ;
   -B       0       0      B      0      0     ;
    0    -12*V   -6*V*L    0    12*V   -6*V*L  ;
    0    6*V*L  2*V*L^2    0   -6*V*L  4*V*L^2 ];

Ks=1/L*[ 0    0       0        0    0       0 ;
         0   6/5     1/10*L    0  -6/5     1/10*L;
         0   1/10*L  2/15*L^2  0  -1/10*L -1/30*L^2;
         0    0        0       0    0       0 ;
         0  -6/5    -1/10*L    0   6/5   -1/10*L;
         0   1/10*L -1/30*L^2  0  -1/10*L 2/15*L^2];
end
