from clustertools import build_datacube


def get(c, v, default=None):
    values = c(v).numpyfy().flatten()
    filtered = list(filter(lambda s: s is not None, values))
    if len(filtered) > 0:
        return filtered[0]
    else:
        return default


if __name__ == "__main__":
    cube = build_datacube("pyxit_train_eval")

    for dataset in cube.domain["dataset"]:
        dcube = cube(dataset=dataset)
        print("{}\t{}\t{}\t{}\t{:0.4f}\t{:0.4f}\t{:0.4f}\t{:0.4f}\t{:0.4f}\t{:0.4f}".format(
            dataset,
            get(dcube, "min_size", default=-1.0),
            get(dcube, "max_size", default=-1.0),
            get(dcube, "colorspace", default=-1.0),
            get(dcube, "cv_best_score", default=-1.0),
            get(dcube, "accuracy", default=-1.0),
            get(dcube, "precision", default=-1.0),
            get(dcube, "recall", default=-1.0),
            get(dcube, "f1-score", default=-1.0),
            get(dcube, "roc_auc", default=-1.0)
        ))
