#!/usr/bin/env bash

source activate tf
export TF_CPP_MIN_LOG_LEVEL=3
export CUDA_VISIBLE_DEVICES=0

DATASET_PATH="[...]"
DEST_PATH=${DATASET_PATH}"/ft_inference"
DATASET="[...]"
TEST="test"
WPATH=${DATASET_PATH}"/working_path"
LOGPATH=${HOME}"/logs/"
N_JOBS=8
BATCH_SIZE=128


python predict_with_network.py --path ${DATASET_PATH} --dataset ${DATASET} --dest ${DEST_PATH} --test ${TEST} \
    --weights_folders_dir ${WPATH} --n_jobs $N_JOBS --testing_batch_size ${BATCH_SIZE} --extract \
    --model "resnet50" > ${LOGPATH}"/resnet50_"${DATASET}"_inference.log" 2>&1

python predict_with_network.py --path ${DATASET_PATH} --dataset ${DATASET} --dest ${DEST_PATH} --test ${TEST} \
    --weights_folders_dir ${WPATH} --n_jobs $N_JOBS --testing_batch_size ${BATCH_SIZE} --extract \
    --model "inception_resnet_v2" > ${LOGPATH}"/inception_resnet_v2_"${DATASET}"_inference.log" 2>&1

python predict_with_network.py --path ${DATASET_PATH} --dataset ${DATASET} --dest ${DEST_PATH} --test ${TEST} \
    --weights_folders_dir ${WPATH} --n_jobs $N_JOBS --testing_batch_size ${BATCH_SIZE} --extract \
    --model "dense_net_201" > ${LOGPATH}"/dense_net_201_"${DATASET}"_inference.log" 2>&1