#!/usr/bin/env bash

source activate tf
export TF_CPP_MIN_LOG_LEVEL=3
export CUDA_VISIBLE_DEVICES=3

DATASET_PATH="[...]"
DATASET="[...]"
TRAIN="train"
VAL="val"
WPATH=${DATASET_PATH}"/working_path"
N_JOBS=8

TR_SEED=42
TR_DENSE_LR=0.01
TR_END_LR=0.00001
TR_DENSE_EPOCHS=5
TR_END_EPOCHS=45

python fine_tune.py --path ${DATASET_PATH} --dataset ${DATASET} --train ${TRAIN} --val ${VAL} --working_path ${WPATH} \
    --n_jobs $N_JOBS --training_seed ${TR_SEED} --training_dense_lr ${TR_DENSE_LR} --training_end_lr ${TR_END_LR} \
    --training_dense_epochs ${TR_DENSE_EPOCHS} --training_end_epochs ${TR_END_EPOCHS} \
    --model "resnet50" --training_batch_size 64 --augment > ${WPATH}"/resnet50_"${DATASET}"_ft.log" 2>&1

python fine_tune.py --path ${DATASET_PATH} --dataset ${DATASET} --train ${TRAIN} --val ${VAL} --working_path ${WPATH} \
    --n_jobs $N_JOBS --training_seed ${TR_SEED} --training_dense_lr ${TR_DENSE_LR} --training_end_lr ${TR_END_LR} \
    --training_dense_epochs ${TR_DENSE_EPOCHS} --training_end_epochs ${TR_END_EPOCHS} \
    --model "inception_resnet_v2" --training_batch_size 32 --augment > ${WPATH}"/inception_resnet_v2_"${DATASET}"_ft.log" 2>&1

python fine_tune.py --path ${DATASET_PATH} --dataset ${DATASET} --train ${TRAIN} --val ${VAL} --working_path ${WPATH} \
    --n_jobs $N_JOBS --training_seed ${TR_SEED} --training_dense_lr ${TR_DENSE_LR} --training_end_lr ${TR_END_LR} \
    --training_dense_epochs ${TR_DENSE_EPOCHS} --training_end_epochs ${TR_END_EPOCHS} \
    --model "dense_net_201" --training_batch_size 32 --augment > ${WPATH}"/dense_net_201_"${DATASET}"_ft.log" 2>&1

#python fine_tune.py --path $PATH --dataset $DATASET --train $TRAIN --val $VAL --working_path $WPATH --n_jobs $N_JOBS \
#    --training_seed $TR_SEED --training_dense_lr $TR_DENSE_LR --training_end_lr $TR_END_LR \
#    --training_dense_epochs $TR_DENSE_EPOCHS --training_end_epochs $TR_END_EPOCHS \
#    --model "inception_v3" --training_batch_size 64 > /data/rmormont/working_path/resnet50_breast_ft_180305.log 2>&1
