from clustertools import ConstrainedParameterSet, set_stdout_logging, Experiment
from clustertools.environment import SlurmEnvironment, InSituEnvironment

from train_eval_on_features_clustertools import TrainEvalOnTop
from util import infer_folder_name

if __name__ == "__main__":
    set_stdout_logging()
    param_set = ConstrainedParameterSet()
    param_set.add_parameters(dataset=[
        "ulg_lbtd2_chimio_necrose",
        "ulb_anapath_lba",
        "cells_no_aug",
        "patterns_no_aug",
        "glomeruli_no_aug",
        "ulg_breast",
        "ulg_lbtd_tissus",
        "ulg_lbtd_lba"
    ])
    param_set.add_parameters(model=[
        "resnet50",
        "inception_resnet_v2",
        "dense_net_201"
    ])
    param_set.add_parameters(method=["svm"])
    param_set.add_parameters(test=["test", "val"])
    param_set.add_constraints(test_folder_constrain=infer_folder_name)

    n_jobs = 8
    param_set.add_parameters(
        path="[...]/features/fine_tuned",
        dest="[...]/features/fine_tuned",
        train="train", n_estimators=1000,
        source="img_net_fine_tuned", reduction=None, layer="last",
        n_jobs=n_jobs
    )
    param_set.add_separator()
    param_set.add_parameters(dataset="ulg_lbtd_lba_new")
    param_set.add_separator()
    param_set.add_parameters(method=["et"])
    experiment = Experiment("eval_fine_tuned", param_set, TrainEvalOnTop)
    SlurmEnvironment(
        time="8-8",
        memory="31900M",
        partition="[...]",
        n_proc=n_jobs
    ).run(experiment)