import sys
import cv2
import time
import numpy as np

import PyCVPR18AC.IO.Writer as iow
import PyCVPR18AC.IO.Loader as lib_loader
import PyCVPR18AC.GameEventClassification.game_event_classification as lib_game_event




filepath = sys.argv[1]
prefix = sys.argv[2]
extension = sys.argv[3]

output_file = sys.argv[4]

frame_number = int(sys.argv[5])

video = lib_loader.VideoLoader(path = filepath, prefix = prefix, extension = extension)


Game_event_Classificator = lib_game_event.Game_event_Classificator()

json = iow.JsonWriter(output_file)

video.set_frame_number(frame_number-1)


while video.read():

	print("Frame number : ", frame_number)

	values_dict = Game_event_Classificator.classify_game_event(video.frame)

	if frame_number == video.number_of_frames+1:
		json.write(frame_number, values_dict["game_event"], len(values_dict["players_box"]), values_dict["barycenter"], values_dict["groupment"], values_dict["main_circle"], values_dict["players_box"], values_dict["view"], values_dict["direction"], True)
		break

	json.write(frame_number, values_dict["game_event"], len(values_dict["players_box"]), values_dict["barycenter"], values_dict["groupment"], values_dict["main_circle"], values_dict["players_box"], values_dict["view"], values_dict["direction"], False)

	frame_number = frame_number + 1
