# Game Event Classification - Python Library

Authors:
--------

Cioppa Anthony <anthony.cioppa@uliege.be> (main author, contact person)
Deliège Adrien <adrien.deliege@uliege.be>
Van Droogenbroeck Marc <m.vandroogenbroeck@uliege.be>

Paper:
------

In return for making this code available, we would appreciate that you cite the following publication on which the code is based:

* A. Cioppa, A. Deliège, M. Van Droogenbroeck. A bottom-up approach based on semantics for the interpretation of the main camera stream in soccer games. In IEEE/CVF Conference on Computer Vision and Pattern Recognition Workshops (CVPRW), June 2018.

@inproceedings{Cioppa2018BottomUp,
	title = {A bottom-up approach based on semantics for the interpretation of the main camera stream in soccer games},
	author = {A. Cioppa, A. Deliège, M. Van Droogenbroeck},
	booktitle = {Proceedings of IEEE/CVF Conference on Computer Vision and Pattern Recognition Workshops (CVPRW)}
	month = {June},
	year = {2017},
	keywords = {semantic segmentation, soccer analysis, semantic classification, deep learning},
	url = {http://hdl.handle.net/2268/222427}
}

Code:
-----


<code>
Permission to use this code without payment of fee is granted for nonprofit educational and research purposes only.
This work may not be copied or reproduced in whole or in part for any purpose. 
All the code is provided without any guarantee.
</code>

This code is meant for demonstration purposes only, it is not bullet proof. The original code that produced the numerical results in the article is programmed in lua, C and C++ which is more tricky to compile. We provide this Python code for transparancy and to show how one can implement easily each function individually and combine them in the simplest way. Furthermore, the weights for the semantic segmentation that we provide are trained on one specific game so you might need to retrain your own network to improve the performances (we provide the structure of the network). Reminder : you only need to annotate 200 images of blobs of lines and players for your particular game.

Libraries:
----------

There are few pre-required libraries that our code needs. If you're running the code in a Linux Ubuntu NVIDIA docker container with tensorflow and python 3 (the docker image that we use is tensorflow 18.05 with python 3), run <code> bash docker_install.sh </code>. Else, install the following libraries manually:

* keras
* numpy
* jupyter
* sklearn
* h5py
* opencv >= 3.0.0
* PyCVPR18AC (our library : using <code> bash development_install.sh </code>)

How to use:
-----------

This code is a python implementation of the methods and algorithms described in the paper presented above. It is composed of three parts:

* Library : Contains the modules with the algorithms for each part of the work comprising : pixel-level extraction, interpretative feature extraction and game event classification. There is a setup file to install it.

* Notebook : Contains several notebooks useful for testing specific parts of the work.

* Script : Contains the main code in python as well as a bash script to easily run the main code.

To use the code, you can run:

<code> bash script /path/to/images/ /path/to/save/results/ </code>

Note that in the script file, you can change the prefix and extension of the image filenames as well as the number of the frame to start with (default : "img", ".png", "1")

Each function of the PyCVPR18AC library can also be used separately by importing their corresponding modules.
