import cv2
import numpy as np

def channel_histogram(img, channel = 0):
	""" 
		Note : 257 bins since bins are divided as [0,1), [1,2), ..., [254,255), [255,256]. If we took
		256 bin, the last bin would have been [254,255] thus concatenating two values.
	"""
	histogram = np.histogram(img[:,:,channel],np.arange(257))
	histogram_list = [histogram[0], np.arange(256)]
	return histogram_list

def histogram_peak(histogram):
	return histogram[1][np.argmax(histogram[0])]