import cv2
import numpy as np


def morphological_opening(img, morph_size):
	kernel = np.ones((morph_size,morph_size),np.uint8) 
	return cv2.morphologyEx(img, cv2.MORPH_OPEN, kernel)


def morphological_closing(img, morph_size):
	kernel = np.ones((morph_size,morph_size),np.uint8) 
	return cv2.morphologyEx(img, cv2.MORPH_CLOSE, kernel)


def gaussian_blur(img, kernel_size, std):
	return cv2.GaussianBlur(img,(kernel_size,kernel_size),std)

def threshold(img, channel = 0, threshmin=None, threshmax = None):
	mask_1 = np.where(img[:,:,channel] > threshmin, 1, 0)
	mask_2 = np.where(img[:,:,channel] < threshmax, 1, 0)
	mask = (mask_1 == 1) & (mask_2 == 1)
	mask = mask.astype("uint8")
	mask[mask == 1] = 255
	return mask