import numpy as np
from collections import Counter
import PyCVPR18AC.Utils.constants as const
from PyCVPR18AC.TemporalAnalysis.memory import Memory

class Smoother:

	def __init__(self, number_samples=1, function="majority"):

		self.number_samples = number_samples
		self.function = function

		self.memory = Memory(self.number_samples)

	def smooth(self, element):

		if self.function=="last":
			return self._last(element)
		if self.function=="bool_majority":
			return self._bool_majority(element)
		if self.function=="moving_average":
			return self._moving_average(element)
		if self.function=="moving_average_2D":
			return self._moving_average_2D(element)
		if self.function=="majority":
			return self._majority(element)
		if self.function=="alpha_map":
			return self._alpha_map(element)



	def _last(self, element):

		if element == const.NO_VALUE:
			if not self.memory.at(0) is None:
				return self.memory.at(0)
			else : 
				return const.NO_VALUE

		self.memory.insert(element)
		return self.memory.at(0)

	def _bool_majority(self, element):

		self.memory.insert(element)

		sum_true = 0
		total_elements = 0

		for item in self.memory:
			if not item is None:
				total_elements = total_elements + 1
				if item == True:
					sum_true = sum_true + 1

		return 2*sum_true >= total_elements

	def _moving_average(self, element):

		self.memory.insert(element)

		return np.mean([i for i in self.memory.values if i != None])

	def _moving_average_2D(self, element):

		self.memory.insert(element)

		dim_1 = []
		dim_2 = []

		for memory_element in self.memory.values:
			if not memory_element is None:
				dim_1.append(memory_element[0])
				dim_2.append(memory_element[1])

		return [np.mean(dim_1), np.mean(dim_2)]


	def _majority(self, element):

		self.memory.insert(element)

		collection = dict(Counter(self.memory.values))

		max_value = 0
		max_key = 0

		for key, value in collection.items():
			if not key is None and value > max_value:
				max_key = key
				max_value = value

		return max_key

	def _alpha_map(self, element):

		alpha = 0.25
		if self.memory.values[0] is None:
			self.memory.insert(element)
			return element
		new_map = (1-alpha)*self.memory.values[0]+alpha*element
		self.memory.insert(new_map)
		return new_map