import cv2
import numpy as np

class PlayerBox:

	def __init__(self, x, y, w, h):
		self.x = x
		self.y = y
		self.width = w
		self.height = h

	def draw(self, frame):
		return cv2.rectangle(np.copy(frame),(self.x,self.y),(self.x+self.width,self.y+self.height),(255,255,0),5)


def extract_player_box(player_map):

	criteria = {"extension" : 10}

	contours = cv2.findContours(player_map,cv2.RETR_TREE,cv2.CHAIN_APPROX_SIMPLE)[1]

	players = []

	mask = np.copy(player_map)

	for contour in contours:
		x, y, w, h = cv2.boundingRect(contour)
		tmp_player = PlayerBox(x-criteria["extension"], y-criteria["extension"], w+2*criteria["extension"], h+2*criteria["extension"])
		mask = cv2.rectangle(mask,(tmp_player.x,tmp_player.y),(tmp_player.x+tmp_player.width,tmp_player.y+tmp_player.height),255,-1)

	contours_mask = cv2.findContours(mask,cv2.RETR_TREE,cv2.CHAIN_APPROX_SIMPLE)[1]
	
	for contour in contours_mask:
		x, y, w, h = cv2.boundingRect(contour)
		players.append(PlayerBox(x, y, w, h))


	return players

def draw_all_players(frame, players):
	frame_player = np.copy(frame)
	for player in players:
		frame_player = player.draw(frame_player)
	return frame_player