import cv2
import numpy as np

import PyCVPR18AC.Utils.constants as const


class JsonWriter:

	def __init__(self, filename):

		self.filename = filename
		self.file = open(self.filename, "a")
		self.file.close()

	def write(self, frame_number, game_event, number_players, barycenter, groupment, main_circle, players, view, direction, last):

		self.file = open(self.filename, "a")

		if frame_number == 1:
			self._start()

		self._beginning(frame_number, const.GAME_EVENT_DICTIONNARY[game_event], number_players)
		self._barycenter(barycenter,groupment)
		self._main_circle(main_circle)
		self._view(const.VIEW_DICTIONNARY[view])
		self._direction(const.DIRECTION_DICTIONNARY[direction])
		self._mean_position("Not available")
		self._players(players)
		self._end_frame(last)

		if last:
			self._end()

		self.file.close()


	def _view(self, view):

		self.file.write("\t\t\t\"view\": \"" + view + "\",\n")

	def _direction(self, direction):

		self.file.write("\t\t\t\"direction\": \"" + direction + "\",\n")

	def _mean_position(self, mean_position):

		self.file.write("\t\t\t\"mean_position\": \"" + mean_position + "\",\n")

	def _start(self):

		self.file.write("{\n")

	def _end_frame(self, last):
		if not last:
			self.file.write("\t\t},\n")
		else:
			self.file.write("\t\t}\n")

	def _end(self):

		self.file.write("}\n")

	def _beginning(self, frame_number, game_event, number_players):

		self.file.write("\t\"" + _str(frame_number) + "\":\n")
		self.file.write("\t\t{\n")
		self.file.write("\t\t\t\"game_event\":\"" + game_event + "\",\n")
		self.file.write("\t\t\t\"n_players\":" + _str(number_players) + ",\n")

	def _barycenter(self, barycenter, groupment):

		self.file.write("\t\t\t\"barycenter\":\n")
		self.file.write("\t\t\t{\n")
		self.file.write("\t\t\t\t\"x\":" + _str(barycenter[0]) + ",\n")
		self.file.write("\t\t\t\t\"y\":" + _str(barycenter[1]) + ",\n")
		self.file.write("\t\t\t\t\"groupment\":"+ _str(groupment) + "\n")
		self.file.write("\t\t\t},\n")

	def _main_circle(self, main_circle):

		if main_circle.exists:
			self.file.write("\t\t\t\"ellipse\":\n")
			self.file.write("\t\t\t{\n")
			self.file.write("\t\t\t\t\"x\":" + _str(main_circle.center_x) + ",\n")
			self.file.write("\t\t\t\t\"y\":" + _str(main_circle.center_y) + ",\n")
			self.file.write("\t\t\t\t\"major\":" + _str(main_circle.major_axis) + ",\n")
			self.file.write("\t\t\t\t\"minor\":" + _str(main_circle.minor_axis) + ",\n")
			self.file.write("\t\t\t\t\"angle\":" + _str(main_circle.angle) + "\n")
			self.file.write("\t\t\t},\n")

		else :
			self.file.write("\t\t\t\"ellipse\":\n")
			self.file.write("\t\t\t{\n")
			self.file.write("\t\t\t\t\"x\":" + _str(const.NO_ELLIPSE_CENTER_X) + ",\n")
			self.file.write("\t\t\t\t\"y\":" + _str(const.NO_ELLIPSE_CENTER_Y) + ",\n")
			self.file.write("\t\t\t\t\"major\":" + _str(const.NO_ELLIPSE_MAJOR_AXIS) + ",\n")
			self.file.write("\t\t\t\t\"minor\":" + _str(const.NO_ELLIPSE_MINOR_AXIS) + ",\n")
			self.file.write("\t\t\t\t\"angle\":" + _str(const.NO_ELLIPSE_ANGLE) + "\n")
			self.file.write("\t\t\t},\n")

	def _players(self, players):

		if len(players) > 0:
			self.file.write("\t\t\t\"players\":\n")
			self.file.write("\t\t\t{\n")
			self.file.write("\t\t\t\t\"x\":[")

			for player in players[:-1]:
				self.file.write(_str(player.x) + ",")

			self.file.write(_str(players[-1].x) + "],\n")
			self.file.write("\t\t\t\t\"y\":[")

			for player in players[:-1]:
				self.file.write(_str(player.y) + ",")

			self.file.write(_str(players[-1].y) + "],\n")
			self.file.write("\t\t\t\t\"width\":[")

			for player in players[:-1]:
				self.file.write(_str(player.width) + ",")

			self.file.write(_str(players[-1].width) + "],\n")
			self.file.write("\t\t\t\t\"height\":[")

			for player in players[:-1]:
				self.file.write(_str(player.height) + ",")

			self.file.write(_str(players[-1].height) + "],\n")
			self.file.write("\t\t\t\t\"value\":[")

			for player in players[:-1]:
				self.file.write(_str(const.NO_VALUE) + ",")

			self.file.write(str(const.NO_VALUE) + "]\n")
			self.file.write("\t\t\t}\n")

def _str(number):
	return str(int(round(number)))