import os
import cv2
import glob
import numpy as np


class VideoLoader:

	def __init__(self, path = "", prefix = "", extension = ""):

		self.path = path

		# Check if the path is of a file or directory
		if os.path.isfile(self.path):

			print("Note : The path specified is a filepath", end = " - ")
			print("Using a Video Capture object in order to retrieve video frames")

			self.isVideo = True							# Boolean between video or set of images
			self.capture = cv2.VideoCapture(self.path)

			if not self.capture.isOpened():
				print("The following file : ", self.path, " could not be opened.")
				print("Please check that the file exist and is accessible.")
				return

		if os.path.isdir(self.path):


			print("Note : The specified path is a folderpath", end = " - ")
			print("Using a list of files in order to retrieve video frames based on the specified prefix and extension")

			self.isVideo = False						# Boolean between video or set of images
			self.filename_list = sorted(glob.glob(self.path + prefix + "*" + extension))
			self.number_of_frames = len(self.filename_list)

		self.frame_counter = 0

		self.frame = None

	def read(self):

		if not self.isVideo:

			self.frame = cv2.imread(self.filename_list[self.frame_counter])
			self.frame = cv2.cvtColor(self.frame, cv2.COLOR_BGR2RGB)



			self.frame_counter = self.frame_counter + 1

			return self.frame_counter < self.number_of_frames


	def reset(self):
		self.frame_counter = 0
		self.frame = None
		
	def release(self):
		print("Releasing video loader")

	def set_frame_number(self, frame_number):
		self.frame_counter = frame_number