import cv2
import time
import numpy as np


import PyCVPR18AC.Players.box as lib_box
import PyCVPR18AC.Field.view as lib_view
import PyCVPR18AC.IO.Loader as lib_loader
import PyCVPR18AC.Lines.lines as lib_line
import PyCVPR18AC.Field.field as lib_field
import PyCVPR18AC.Lines.ellipse as lib_ellipse
import PyCVPR18AC.Players.players as lib_player
import PyCVPR18AC.Players.players as lib_player

from PyCVPR18AC.TemporalAnalysis.smoother import Smoother

import PyCVPR18AC.GameEventClassification.decision_tree as lib_decision_tree

import PyCVPR18AC.Utils.constants as const





class Game_event_Classificator:

	def __init__(self):

		self.parameters = {	"memory_size_view":1,
							"memory_size_main_circle":15,
							"memory_size_barycenter":15,
							"memory_size_groupment":15,
							"memory_size_direction":15,
							"memory_size_game_event":15,
						}

		self.view_smoother = Smoother(number_samples=self.parameters["memory_size_view"], function="last")
		self.main_circle_smoother = Smoother(number_samples=self.parameters["memory_size_main_circle"], function="bool_majority")
		self.barycenter_smoother = Smoother(number_samples=self.parameters["memory_size_barycenter"], function="moving_average_2D")
		self.groupment_smoother = Smoother(number_samples=self.parameters["memory_size_groupment"], function="moving_average")
		self.direction_smoother = Smoother(number_samples=self.parameters["memory_size_direction"], function="majority")
		self.game_event_smoother = Smoother(number_samples=self.parameters["memory_size_game_event"], function="majority")

		self.LineExtractor = lib_line.LineExtraction()
		self.PlayerExtractor = lib_player.PlayerExtraction()
		self.ransac = lib_ellipse.EllipseRANSAC()
		self.DecisionTree = lib_decision_tree.DecisionTree()

		self.previous_distances = [const.NO_VALUE, const.NO_VALUE]


	def classify_game_event(self, frame):



		'''

		Extraction of the pixel-level semantics : field, player and line.

		'''

		# Extraction of the field binary map

		field_map = lib_field.compute_field_mask(frame)

		# Extraction of the player binary map

		player_map = self.PlayerExtractor.compute_player_mask(frame)

		# Extraction of the line binary map

		line_map = self.LineExtractor.compute_line_mask(frame)



		'''

		Extraction of the interpretative semantic features

		'''

		# Extraction and smoothing of the view information

		view = lib_view.compute_view(field_map)
		view = self.view_smoother.smooth(view)

		# Extraction of the main_circle

		main_circle = self.ransac.find_ellipse(line_map)
		main_circle_existance = self.main_circle_smoother.smooth(main_circle.exists)

		# Extraction of the barycenter of the players

		barycenter = lib_player.compute_mean_position(player_map)
		barycenter = self.barycenter_smoother.smooth(barycenter)

		# Extraction of the groupment of the players

		groupment = lib_player.compute_groupment(player_map)
		groupment = self.groupment_smoother.smooth(groupment)

		# Extraction of the distance and direction

		distances = lib_player.compute_distance(barycenter, field_map, main_circle)
		direction = lib_player.compute_direction(distances, self.previous_distances)
		self.previous_distances = distances
		direction = self.direction_smoother.smooth(direction)

		# Extraction of the bounding rectangles around the players

		players_box = lib_box.extract_player_box(player_map)


		'''

		Extraction of the game event using the semantic decision tree

		'''

		# Decision tree classification

		game_event = self.DecisionTree.classify_game_event(view, main_circle_existance, groupment, direction)
		game_event = self.game_event_smoother.smooth(game_event)

		return_dictionnary = {	"game_event":game_event,
								"players_box":players_box,
								"barycenter":barycenter,
								"groupment":groupment,
								"main_circle":main_circle,
								"view":view,
								"direction":direction
		}

		return return_dictionnary