import numpy as np
import PyCVPR18AC.Utils.constants as const
from PyCVPR18AC.TemporalAnalysis.smoother import Smoother



class DecisionTree:

	def __init__(self):
		self.criteria = {"groupment_threshold":475}



	def classify_game_event(self, view, main_circle, groupment, direction):

		if view == const.GOAL_VIEW:
			return const.GOAL_OR_OPPORTUNITY

		if view == const.CENTER_VIEW:
			if main_circle:
				return const.MIDDLE
			else:
				if groupment < self.criteria["groupment_threshold"]:
					return const.ATTACK
				else:
					return const.DEFENSE

		if view == const.SIDE_VIEW:
			if main_circle:
				if groupment < self.criteria["groupment_threshold"]:
					return const.ATTACK
				else:
					if direction == const.TOWARD_CENTER:
						return const.DEFENSE
					else:
						return const.ATTACK
			else:
				if groupment < self.criteria["groupment_threshold"]:
					return const.ATTACK
				else:
					return const.DEFENSE

		return const.NO_EVENT
