import cv2
import numpy as np
import PyCVPR18AC.Utils.constants as const
import PyCVPR18AC.Utils.statistics as stats
import PyCVPR18AC.Utils.filterOperations as filters

def compute_view(binary_map):

	criterion = {"ratio_areas":0.025,
				"angle_threshold":0.15}

	intersections = compute_intersection_points(binary_map)

	if len(intersections) != 2:
		return const.VIEW_ERROR

	if detect_corner(binary_map, intersections) > criterion["ratio_areas"]:
		return const.SIDE_VIEW

	slope = compute_slope(intersections[0],intersections[1])

	if slope > criterion["angle_threshold"]:
		return const.GOAL_VIEW

	return const.CENTER_VIEW





def compute_intersection_points(binary_map):

	intersections = []


	good_value = [255] 

	column_counter_left = 0
	column_counter_right = -1

	while True:
		left_line = binary_map[:,column_counter_left]
		if sum(left_line) == 0:
			column_counter_left = column_counter_left +1
			continue
		itemindex = np.where(left_line > 0)

		intersections.append([column_counter_left,itemindex[0][0]])

		break

	while True:
		right_line = binary_map[:,column_counter_right]
		if sum(right_line) == 0:
			column_counter_right = column_counter_right -1
			continue
		itemindex = np.where(right_line > 0)

		intersections.append([binary_map.shape[1] + column_counter_right,itemindex[0][0]])

		break

	return intersections





def compute_slope(point1, point2):

	if abs(point1[0]-point2[0]) < 1:
		return 100

	angle = abs((point1[1]-point2[1])/(point1[0]-point2[0]))
	return angle


def detect_corner(binary_map, intersections):

	
	
	field_separation = np.copy(binary_map)

	cv2.line(field_separation, (intersections[0][0],intersections[0][1]), (intersections[1][0],intersections[1][1]),0, 4)

	contours = cv2.findContours(field_separation,cv2.RETR_TREE,cv2.CHAIN_APPROX_SIMPLE)[1]

	#Find the greatest area contour

	areas = []

	for contour in contours:
		areas.append(cv2.contourArea(contour))

	max_index = np.argmax(areas)
	max_area = areas.pop(max_index)

	remaining_area = sum(areas)

	return (remaining_area/max_area)




	