import cv2
import numpy as np
import PyCVPR18AC.Utils.statistics as stats
import PyCVPR18AC.Utils.filterOperations as filters

def compute_field_mask(frame):

	# Parameters
	threshold_width = 10
	gaussian_blur_size = 9
	gaussian_blur_std = 1
	max_number_of_contour_edges = 20



	frame_hsv = cv2.cvtColor(frame, cv2.COLOR_RGB2HSV)
	frame_hsv_filtered = filters.gaussian_blur(frame_hsv, gaussian_blur_size, gaussian_blur_std)

	histogram = stats.channel_histogram(frame_hsv_filtered, channel = 0)
	histogram_peak = stats.histogram_peak(histogram)

	thresholded_mask = filters.threshold(frame_hsv_filtered, channel = 0, threshmin = histogram_peak - threshold_width, threshmax =histogram_peak + threshold_width)

	filtered_mask = filters.morphological_opening(thresholded_mask,15)
	filtered_mask = filters.morphological_closing(filtered_mask,17)

	contours = cv2.findContours(filtered_mask,cv2.RETR_TREE,cv2.CHAIN_APPROX_SIMPLE)[1]

	areas = []

	for contour in contours:
		areas.append(cv2.contourArea(contour))

	max_index = np.argmax(areas)

	# Approximation and convex Hull
	field_contour = contours[max_index]
	threshold_contour_approximation = 0

	while len(field_contour) > max_number_of_contour_edges:
		threshold_contour_approximation = threshold_contour_approximation +1
		field_contour = cv2.approxPolyDP(field_contour,threshold_contour_approximation,True)


	field_contour = cv2.convexHull(field_contour)

	filtered_mask.fill(0)
	cv2.drawContours(filtered_mask, [field_contour], 0, 255, -1)


	return filtered_mask

