/* Benjamin Laugraud <blaugraud@uliege.be>
 * 2018
 */
#include "PolyFrameDifference.h"

#include <cmath>

using namespace bgslibrary::algorithms;

PolyFrameDifference::PolyFrameDifference() :
threshold(15)
{
  std::cout << "PolyFrameDifference()" << std::endl;
  setup("./config/PolyFrameDifference.xml");
}

PolyFrameDifference::~PolyFrameDifference()
{
  std::cout << "~PolyFrameDifference()" << std::endl;
}

void PolyFrameDifference::process(const cv::Mat &img_input, cv::Mat &img_output, cv::Mat &img_bgmodel)
{
  /* Initialization */
  init(img_input, img_output, img_bgmodel);
  cv::Mat& previous_frame = img_background;

  if (firstTime) {
    img_input.copyTo(previous_frame);
    firstTime = false;
    return;
  }

  /* Background image */
  previous_frame.copyTo(img_bgmodel);

  /* Segmentation map */
  unsigned char* buffer_input  = img_input.data;      // Current frame    - C3
  unsigned char* buffer_prev   = previous_frame.data; // Previous frame   - C3
  unsigned char* buffer_output = img_output.data;     // Segmentation map - C1

  int _threshold = 3 * pow(threshold, 2);

  /* For each pixel */
  for (int row = 0; row < img_input.rows; ++row) {
    for (int col = 0; col < img_input.cols; ++col) {
      int distance = pow((int)buffer_input[0] - buffer_prev[0], 2) +
                     pow((int)buffer_input[1] - buffer_prev[1], 2) +
                     pow((int)buffer_input[2] - buffer_prev[2], 2) ;

      *buffer_output = (distance > _threshold) ? 255 : 0;
      buffer_input += 3; buffer_prev += 3; ++buffer_output;
    }
  }

  /* Visualization */
#ifndef MEX_COMPILE_FLAG
  if (showOutput)
    imshow("Polychromatic Frame Difference", img_output);
#endif

  /* Save the current frame as the previous one */
  img_input.copyTo(previous_frame);
}

void PolyFrameDifference::saveConfig()
{
  CvFileStorage* fs = cvOpenFileStorage(config_xml.c_str(), nullptr, CV_STORAGE_WRITE);

  cvWriteInt(fs, "threshold", threshold);
  cvWriteInt(fs, "showOutput", showOutput);

  cvReleaseFileStorage(&fs);
}

void PolyFrameDifference::loadConfig()
{
  CvFileStorage* fs = cvOpenFileStorage(config_xml.c_str(), nullptr, CV_STORAGE_READ);

  threshold = cvReadIntByName(fs, nullptr, "threshold", 15);
  showOutput = cvReadIntByName(fs, nullptr, "showOutput", true);

  cvReleaseFileStorage(&fs);
}
