/* Benjamin Laugraud <blaugraud@uliege.be>
 * 2018
 */
#include <fstream>
#include <iomanip>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>

#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>

#include "package_bgs/CodeBook.h"
#include "package_bgs/FrameDifference.h"
#include "package_bgs/PolyFrameDifference.h"

#define FILES_PATH   "/home/benlaug/Bureau/code/cdnet.txt"
#define CDNET_PATH   "/home/benlaug/Bureau/dataset2014/dataset"
#define RESULTS_PATH "/home/benlaug/Bureau/results"

#define VISUALIZATION

using namespace cv;
using namespace std;
using namespace bgslibrary::algorithms;

vector<string> list_files() {
  vector<string> files;
  ifstream ifs(FILES_PATH);
  string buffer;

  while (getline(ifs, buffer))
    files.push_back(buffer);

  return files;
}

vector<int> read_temporal_roi(string sequence) {
  vector<int> temporal_roi;
  ifstream ifs(string(CDNET_PATH) + "/" + sequence + "/temporalROI.txt");
  int frame;

  ifs >> frame;
  temporal_roi.push_back(frame);
  ifs >> frame;
  temporal_roi.push_back(frame);

  return temporal_roi;
}

int main() {
  vector<string> files = list_files();

  /* For each sequence */
  for (vector<string>::size_type file_idx = 0; file_idx < files.size(); ++file_idx) {
    cout << files[file_idx] << endl;

    vector<int> temporal_roi = read_temporal_roi(files[file_idx]);
    int frame_begin = temporal_roi[0];
    int frame_end   = temporal_roi[1];
    cout << frame_begin << " - " << frame_end << endl;

    IBGS* subtractor = new PolyFrameDifference;

    /* For each frame */
    for (int frame_num = 1; frame_num <= frame_end; ++frame_num) {
      stringstream frame_path;
      frame_path << CDNET_PATH << "/" << files[file_idx] << "/input/in" << setw(6) << setfill('0') << frame_num << ".jpg";

      Mat frame = imread(frame_path.str());

#ifdef VISUALIZATION
      imshow("Input frame", frame);
      waitKey(1);
#endif

      Mat segmentation(frame.rows, frame.cols, CV_8UC3);
      Mat bg_model(frame.rows, frame.cols, CV_8UC3);

      subtractor->process(frame, segmentation, bg_model);

      if (frame_num >= frame_begin) {
        stringstream write_path;
        write_path << RESULTS_PATH << "/" << files[file_idx] << "/bin" << setw(6) << setfill('0') << frame_num << ".png";
        imwrite(write_path.str(), segmentation);
      }
    }

    delete subtractor;
  }
}
