% This script if part of the GPexp suite for the analysis of steady-state
% experimental data. It reads all the GPexp results files in the current
% directory and outputs them in the summary.csv spreadsheet
%--------------------------------------------------------------------------
% Written by S. Quoilin, University of Liège, 2013-2015

filename = 'summary.csv';

list_files = dir('*.mat');
list_files = {list_files.name};

list_var = {'train.mae','CV.mae','train.rsquare','CV.rsquare','CV.pmae','AIC', 'BIC'};
list_var_special = {'Outliers'};

Nfiles = length(list_files);
Nvar = length(list_var);

data = zeros(Nfiles,Nvar);
cells = cell(Nfiles+1,Nvar+1+length(list_var_special));

for i=1:Nfiles 
    load(list_files{i});
    cells{i+1,1} = list_files{i};
    for j =1:Nvar
        var = strsplit(list_var{j},'.');
        if length(var) == 1
            try
            data(i,j) = getfield(results,var{1});
            end
        elseif length(var)==2
            try
            data(i,j) = getfield(getfield(results,var{1}),var{2});
            end
        else 
            disp(['too many levels in variable ' list_var{j}]);
        end
        cells{i+1,j+1} = num2str(data(i,j));
    end
    % Outliers:
    idx = find(abs(results.outliers)>=1.96);
    temp = ' ';
    for k=1:length(idx)
        temp = strjoin({temp, num2str(idx(k))},' ');
    end
    cells{i+1,Nvar + 2} = temp;
            
end;


for j=1:Nvar
    cells{1,j+1} = list_var{j};
end
for j=Nvar+1:Nvar+length(list_var_special)
    cells{1,j+1} = list_var_special{j-Nvar};
end

separator = ',';
decimal = '.';


%% Write file
fid = fopen(filename, 'w');

for z=1:size(cells, 1)
    for s=1:size(cells, 2)
        
        var = eval(['cells{z,s}']);
        % If zero, then empty cell
        if size(var, 1) == 0
            var = '';
        end
        % If numeric -> String
        if isnumeric(var)
            var = num2str(var);
            % Conversion of decimal separator (4 Europe & South America)
            % http://commons.wikimedia.org/wiki/File:DecimalSeparator.svg
            if decimal ~= '.'
                var = strrep(var, '.', decimal);
            end
        end
        % If logical -> 'true' or 'false'
        if islogical(var)
            if var == 1
                var = 'TRUE';
            else
                var = 'FALSE';
            end
        end
        % If newer version of Excel -> Quotes 4 Strings
        %var = ['"' var '"'];
        
        % OUTPUT value
        fprintf(fid, '%s', var);
        
        % OUTPUT separator
        if s ~= size(cells, 2)
            fprintf(fid, separator);
        end
    end
    if z ~= size(cells, 1) % prevent a empty line at EOF
        % OUTPUT newline
        fprintf(fid, '\n');
    end
end
% Closing file
fclose(fid);



