function [ help_string ] = help_msg(name)
%HELP_MSG Function that returns an help message for data input
%   name is a string containing the required help msg

if strcmp(name,'raw_data')
    help_string = ['<html>' ...
                    '<b>Data file</b> <br>' ...
                    'The data file passed to GPExp must contain a data array and the headers: <br>' ...
                    '<i>.mat file:</i> <br>' ...
                    '... The data variable is an array that contains the numerical data. Each row corresponds  <br>' ...
                    'to a data sample, each column corresponds to a variable <br>' ...
                    '... The header variable is a cell array containing the variable names <br>' ...
                    '<i>.csv, .xls, or .xlsx file:</i> <br> ' ...
                    '... The first row contains the column headers, the next rows are the data <br>' ...
                    'In the further data input procedure, variable are referred to by their header. It is  <br>' ...
                    'therefore important to ensure that the headers match the data' ...
                    '</html>'
                    ];
elseif strcmp(name,'select_io')
    help_string = ['<html>' ...
                    '<b>Selection of inputs and output</b> <br>' ...        
                   'This defines the subset of the inputs to be considered for the  <br>' ...
                   'processing, as well as the output to be considered. One single output  <br>' ...
                   'must be selected, whereas multiple inputs can be selected <br>' ...
                    '</html>'
                    ];                   
elseif strcmp(name,'include_time')
    help_string = ['<html>' ...
                     '<b>Include time as an explanatory variable? </b> <br>' ...  
                     'If the consider_temporality variable is set to true, the index of the  <br>' ...
                     'samples is included in the input matrix. This allows evaluating  <br>' ...
                     'time-related effects, such as the progressive decrease in efficiency. <br>' ... 
                     'This option should however be used with care since most of the data sets  <br>' ...
                     'present a dependency with time, related to how the experimental campaign  <br>' ... 
                     'was designed.          <br>' ...       
                    '</html>'
                    ];                  
elseif strcmp(name,'folds')
    help_string = ['<html>' ...                
                    '<b> Number of folds </b> <br>' ... 
                    'GPExp results are cross-validation-based: all the performance <br> ' ...
                    'indicators are computed on data points that were not used to train de <br>' ...
                    'model. The number of data points to leave outside of the training set can <br>' ...
                    'be user-defined through the "kfolds" parameter. <br>' ...  
                    ' <br>' ... 
                    'kfolds > 1 :  <br>' ... 
                    'The data is randomly split into k folds. The model is trained using k-1 <br>' ...
                    'folds and the error indicators are computed using the last fold. This is <br>' ...
                    'done iteratively for each fold. <br>' ... 
                    ' <br>' ... 
                    'kfolds == 1 : <br>' ... 
                    'Split in half: the data samples are split into two folds. The model is <br>' ...
                    'trained on one of them and its accuracy is checked using the second one. <br>' ... 
                    ' <br>' ... 
                    'kfolds == 0 : <br>' ... 
                    'Leave-one-out: the model is trained on all samples minus one (used for <br>' ...
                    'the cross-validation). This is equivalent to kfolds == Nsamples <br>' ... 
                    ' <br>' ... 
                    'kfolds == -1 :  <br>' ... 
                    'Ignore kfold cross-validation (not recommended). All data samples are  <br>' ...
                    'used to train the model. <br>' ... 
                    ' <br>' ... 
                    'Default value: 0 <br>' ... 
                    '</html>'
                    ]; 
elseif strcmp(name,'permutations')
    help_string = ['<html>' ...     
                    '<b> Number of permutations </b>  <br>' ... 
                    'To assess the significance of the regression performance compared to the  <br>' ... 
                    'null hypothesis, permutations are used:  <br>' ... 
                    'the input rows are randomly permuted to obtain a “baseline” model  <br>' ... 
                    'performance (i.e. the performance of the regression for a totally random <br>' ... 
                    'and non-correlated set of inputs/output). The “true” model performance is  <br>' ... 
                    'then compared to the baseline level. <br>' ... 
                    'Typically, a model performance is significant (i.e. there is a significant  <br>' ... 
                    'relationship between inputs and output) if the performance obtained by  <br>' ... 
                    'chance does not exceed or equal the true model performance more than  <br>' ... 
                    '5 per cent of the time (p < 0.05). <br>' ... 
                    ' <br>' ... 
                    'It should be noted that permutations significantly increase the <br>' ... 
                    'computational time. If the proof of a relationship between the output and <br>' ... 
                    'the inputs is not critical for the user, permutations should not be used. <br>' ... 
                    ' <br>' ... 
                    'The number of permutation can be set to zero to disable this option <br>' ... 
                    'If used, it should be set to a number sufficient to ensure statistical <br>' ... 
                    'relevance. <br>' ... 
                    ' <br>' ... 
                    'NB: the permutation method uses cross-validation, kfolds must therefore <br>' ... 
                    'be set to a positive value. <br>' ... 
                    ' <br>' ... 
                    'Default value: 0       <br>' ...           
                    '</html>'
                    ]; 
                
elseif strcmp(name,'ngrid')
    help_string = ['<html>' ...                    
                    '<b>3D plotting options</b> <br>' ... 
                    'Ngrid allows setting the number of grid points in one direction (the <br>' ... 
                    'final number is Ngrid²). <br>' ... 
                    'If not specified, Ngrid is set by default to 20 <br>' ... 
                    '  <br>' ... 
                    '</html>'
                    ];         
elseif strcmp(name,'plot_inputs')
    help_string = ['<html>' ...                    
                    '<b>3D plotting options</b> <br>' ... 
                    'Select the names of the inputs variables to be plotted. ' ... 
                    'final number is Ngrid²). <br>' ... 
                    'If not specificed, the two most relevant variables (i.e. the ones with <br>' ... 
                    'the lowest lengthscales) are plotted  <br>' ...    
                    '</html>'
                    ];                   
elseif strcmp(name,'kernel')
    help_string = ['<html>' ...                    
                    '<b> Definition of the kernel</b> <br>' ... 
                    ' These parameters should be modified by experienced users only.  <br>' ... 
                    '  <br>' ... 
                    ' Definition of the covariance function. Default is square exponential with <br>' ... 
                    ' automatic relevant detection (SEard)    <br>' ... 
                    '</html>'
                    ];   
elseif strcmp(name,'hyperparameters')
    help_string = ['<html>' ...                    
                    '<b> Definition of the hyperparameters.</b> <br>' ... 
                    ' These parameters should be modified by experienced users only.  <br>' ... 
                    '  <br>' ... 
                    ' Defining the hyperparameters  avoids the use of the <br>' ...
                    ' optimization algorithm and can be activated if the latter has been run at <br>' ...
                    ' least once before. The hyperparameters resulting of the optimization can <br>' ...
                    ' be obtained in the results variable (results.hyp). <br>' ...
                    ' <br>' ...
                    ' In general three sets of hyperparameters must be defined, corresponding <br>' ...
                    ' to the mean function, the covariance function, and the likelihood <br>' ...
                    ' function. In GPExp, the mean function is set to 0 => there is ne need for <br>' ...
                    ' hyperparameters. If an ARD kernel is used (most recommended case), the <br>' ...
                    ' hyperparameter of the covariance function are the logarithmic lengthscales  <br>' ...
                    ' for each dimension and the log standard deviation. The likelihood function of <br>' ...
                    ' the prior is specified to be gaussian in GPExp. It corresponds to the <br>' ...
                    ' expected noise level and is defined by the log of its standard deviation. <br>' ...
                    ' <br>' ...
                    ' If undefined, the parameters are obtained by minimizing the marginal <br>' ...
                    ' likelihood. If defined, the hyperparameters are imposed for the "train" <br>' ...
                    ' regression (i.e. with all data samples) and used as guesses for the <br>' ...
                    ' cross-validations. <br>' ...  
                    '</html>'
                    ];                  
elseif strcmp(name,'final_data')
    help_string = ['<html>' ...                    
                    '<b> Final Data</b> <br>' ... 
                    'The final data comprises the raw data and all user inputs such as variable  <br>' ... 
                    'selection, number of folds, permuations, etc   <br>' ... 
                    ' <br>' ...                    
                    'The final data has gone through a sanity check is therefore suitable to be <br>' ... 
                    'processed by GPexp <br>' ... 
                    ' <br>' ...
                    'It can be saved in the form of a .mat file to be reload later <br>' ... 
                    ' <br>' ...                    
                    '</html>'
                    ];       
elseif strcmp(name,'test')
    help_string = ['<html> ' ...
                    '<b> title </b> <br> ' ...
                    'rebjioe frejzio <br> ' ...
                    'blabla' ...
                    '</html>' ];
else
    help_string = ' ';
end




end

