%Computation of the focus parameter based on the work of (Lecuona et al, 2000)
%Input parameter:
%image = Image on which the image analysis will be applied in order to
%detect the droplet.
%dia = the droplet diameter [µm]
%reso = spatial resolution of the image [µm/pixel]
%Output parameter:
%inf = the degree of focus of the droplet

function [inf] = Focus(Img,dia,reso)

    %Computation of the gradients
    gv = imfilter(double(Img),fspecial('sobel')'/8,'replicate');
    gh = imfilter(double(Img),fspecial('sobel') /8,'replicate');
    Grad=sqrt(gv.^2+gh.^2);
    
    %Ordering of the gradient in a growing order
    Grad=sort(Grad(:),'descend');
    Peri=dia*pi/(reso);
    a=round(Peri/2)-3;b=round(Peri/2)+3;
    if a<1
        a=1;
    end
    if b>size(Grad,1)
        b=size(Grad,1);
    end
    
    %Computation of the mean gradient in the droplet edge using a rank filter based on the perimeter size
    Gradmax=mean(Grad(a:b));
    
    %Ordering of the pixel intensity in a descending order in order to compute the intensity of the backgroud 
    ImgBack=double(sort(Img(:)));
    L=size(ImgBack,1);
    IBack=mean(ImgBack(round(0.80*L):round(0.9*L)));

    %The light intensity of the particle is considered equal to the average of the 5 lowest intensity 
    Imin=mean(mean(ImgBack(1:5)));
    
    %Calcul du param�tre de focalisation
    Gradcomp=abs((Imin-IBack));
    inf=Gradmax/Gradcomp;
end