%Drop size distribution display
function D=DropSizeDistribution(Droplet,delai,reso,diam_max)
stepstep=50;
%Extraction des param�tres de la structure "goutte"
%--------------------------------------------------
for i=1:length(Droplet)
   Dia(i)=Droplet(i).diametre;
   Vol(i)=Droplet(i).volume;
   Vel(i)=Droplet(i).vit;
end

%Correction des fractions volumiques
%-----------------------------------

Fcor=Correction(Vel,Dia,delai,reso);

%loglog plot of the velocity vs diameter
%---------------------------------------------------

figure,loglog(Dia*10^6,Vel,'*'),xlabel('Diameter [µm]'),ylabel('Velocity [m/s]')
xlim([0 3000]),ylim([1e-1 1.5e1])

%Cr�ation de vecteur class� de volume et diam�tre
%-----------------------------------------------

VolCor=Vol.*Fcor;

Temp=[Dia;VolCor];
Temp2=sortrows(Temp',1);
d1=Temp2(:,1)*10^6;
vc1=Temp2(:,2);
vc2=cumsum(vc1);
vc3=100*vc2/sum(vc1); 


[~,ind10]=min(abs(vc3-10));
D.V10=d1(ind10);

[~,ind50]=min(abs(vc3-50));
D.V50=d1(ind50);

[~,ind90]=min(abs(vc3-90));
D.V90=d1(ind90);

D.VM=median(d1);
D.span=(D.V90-D.V10)/D.V50;
D.gouttes=length(Droplet);
D.volume=sum(Vol);
D.volume_corr=sum(vc3);



%Cr�ation des classes
%--------------------

i=0;
for classe=0:stepstep:diam_max
    i=i+1;
    X(i)=classe;
    ind= Dia*10^6>classe-stepstep/2 & Dia*10^6<classe+stepstep/2;
    Velmoy(i)=mean(Vel(ind));
    Velecart(i)=std(Vel(ind));
    Y(i)=sum(Vol(ind));
end


%Corrected volume
%--------------

volcor=Vol.*Fcor;
i=0;
for classe=0:stepstep:diam_max
    i=i+1;
    ind=find(Dia*10^6>classe-stepstep/2 & Dia*10^6<classe+stepstep/2);
    Y(i)=sum(volcor(ind));  
    FCOR(i)=mean(Fcor(ind));
    vel(i)=mean(Vel(ind));
end

figure,[AX,h1,h2]=plotyy(X,100*Y/sum(Y),d1,vc3,'bar','plot');
set(h2,'color','red','LineWidth',2)
set(get(AX(1),'Ylabel'),'String','\fontsize{16} Relative volume [%]')
set(AX(1),'YTick',[0 5 10 15 20 25])
set(AX(2),'YTick',[0 20 40 60 80 100])
set(AX(1),'FontSize',14)
set(AX(2),'FontSize',14)
set(get(AX(2),'Ylabel'),'String','\fontsize{16} Cumulative relative volume [%]') 
xlabel('\fontsize{16} Diameter [µm]');
set(AX(2),'Ycolor','r')
set(AX(1),'YColor','b')
set(AX(1),'xlim',([0 diam_max])),set(AX(2),'xlim',([0 diam_max]))
set(AX(1),'ylim',([0 25])),set(AX(2),'ylim',([0 100]))
%print('-dtiff','-r300','DSD.png')


%Average speed in respect to the diameter
%-----------------------------------------

figure;plot(X,vel,'k--')
xlim([0 diam_max])
ylim([0 20])
xlabel('Diameter [µm]'),ylabel('Velocity [m/s]')






























