%D�placement
%-------------------

%Draw on the figure the displacement of the droplets
function Displacement(Droplet,x1)

    figure,imshow(x1);hold on;

    for n=1:size(Droplet,2)
        G=Droplet(n);

        %Dessin de la goutte (cercle de m�me diam�tre)
        radius=round(G.diametre(1)./(2*9.6*10^-6));
        center1=round(G.centre(1,:));
        THETA=linspace(0,2*pi,50);
        RHO=ones(1,50)*radius;
        [X,Y] = pol2cart(THETA,RHO);
        X=X+center1(1);
        Y=Y+center1(2);
        plot(X,Y,'-r','linewidth',2);

        %Dessin du d�placement
        center2=round(G.centre(2,:));
        line([center1(1) center2(1)],[center1(2) center2(2)],'color','k')
        line([center2(1)-5 center2(1)],[center2(2)-5 center2(2)],'color','k')
        line([center2(1)+5 center2(1)],[center2(2)-5 center2(2)],'color','k')

    end
end