%Correction of the volumetric fractions in order to take in account to the unequal probability of sampling of each droplet.
%----------------------------------
%Input parameters:
%Vel=Velocity [m/s]
%Dia=Diameter [m]
%delay= Time between two frames [s]
%reso= resolution of the imaging system [m/pixel]
%Computation of the corrected Field of View (FOV) and Depth of Field (DOF) according to the droplet speed (Vel) and size (Dia).
function [Corf]=Correction(Vel,Dia,delay,reso)
FOV=((1024*reso-(Dia/2))-(Vel*delay)).*((1280*reso-(Dia/2))); 
DOF=0.85.*Dia+0.00078;
P=(FOV.*DOF./Vel); 
Corf=1./P;
