%Position and size of the droplets located on the image
%----------------------------------------------------
%Input parameters:
%image = Image on which the image analysis will be applied in order to
%detect the droplet.
%reso = spatial resolution of the image [µm/pixel]
%circ_inf, circ_up = the minimal and the maximal circularity allowed
% T = value of the threshold used for the first detection of the droplet a
% usual value is around 0.05 - 0.1. It depends of the image contrast
%Output parameters:
%C = the centroid position of the droplets
%D = the diameter of the droplets
%Dof = the depth of field of the droplets
%inf = the focus degree of the droplet

function [C,D,Dof,inf]=DropSizing(image,reso,circ_inf,circ_up,T)

se=strel('disk',3);
se1=strel('disk',2);

%Computation of the gradient
[~ , ~, FX,FY]=edge(image,'sobel');
Grad=sqrt(FX.^2+FY.^2);

Grad1=abs(Grad);
Grad2=Grad1;
Grad2(Grad2>T)=1;
Grad2(Grad2<T)=0;
Grad3=imfill(Grad2,'holes');
Grad4=imerode(Grad3,se);
Grad5=imdilate(Grad4,se);
Grad6=imclearborder(Grad5);
Grad7=logical(Grad6);
d=regionprops(Grad7,'Centroid','Area','EquivDiameter','PixelIdxList','Extrema');

%Prealocation of the matrix
centre=cat(1,d.Centroid);
diametre=cat(1,d.EquivDiameter);
L=size(diametre,1);SubImage=cell(L,1);
Dia=zeros(L,1);Centre=zeros(L,2);Circ=zeros(L,1);DOF=zeros(L,1);
Select=zeros(L,1);inf=zeros(L,1);

%Creation of the subimage based on the localized droplet
for j=1:L
    ind1=round((centre(j,2))-diametre(j));
    ind2=round((centre(j,2))+diametre(j));
    ind3=round((centre(j,1))-diametre(j));
    ind4=round((centre(j,1))+diametre(j));
    if ind1<1
        ind1=1;
    end
    if ind2>size(image,1)
        ind2=size(image,1);
    end
    if ind3<1
        ind3=1;
    end
    if ind4>size(image,2)
        ind4=size(image,2);
    end
    
    SubImage{j}=image(ind1:ind2,ind3:ind4);
    c=[ind3 ind1 ind4-ind3 ind2-ind1];

    %Characterization of each droplet using the Canny filter (Size and location)
    BW=edge(SubImage{j},'canny');
    BW1=imclose(BW,se1);
    BW2=imfill(BW1,'holes');
    BW3=imclearborder(BW2);
    d=regionprops(logical(BW3),'Centroid','Area','Perimeter');
    
    if size(d,1)==1
        Centre(j,:)=d.Centroid+[c(1) c(2)];
        Area=d.Area;
        Dia(j)=((2*sqrt((Area)/pi))-1)*reso;
        Circ(j)=d.Area*4*pi/(d.Perimeter)^2;
    elseif size(d,1)>1 
        clear temp
        for l=1:length(d)
            temp(l)=d(l).Area;
        end       
        [D,I]=max(temp);
        Dia(j)=((2*sqrt(D/pi))-1)*reso;
        Centre(j,:)=d(I,:).Centroid+[c(1) c(2)];
        Circ(j)=d(I).Area*4*pi/(d(I).Perimeter)^2;
    else
        Dia(j)=0;
        Centre(j,:)=[0 0];
        Circ(j)=0;
    end
    
    %Computation of the focus parameter for each droplet
    [inf(j)] = Focus(SubImage{j},Dia(j),reso);
    
    %Selection of the droplet with a sufficient degree of focus
    [Select(j)]=Selection(inf(j),Dia(j)*10^6,Circ(j),circ_inf,circ_up);
   
end
ind=find(Select==1);
C=Centre(ind,:);
D=Dia(ind);
Dof=DOF(ind);
inf=inf(ind);
end