%Demo script for droplet sizing
%---------------------------------------------------------------
clear all ;
close all;

%Settings
%---------------------------------------------------------

reso=9.86e-6; %Spatial resolution
diff=.075; %Diff�rence admise pour le diam�tre lors du suivi [%/100]
angle=40;  %Angle admis lors du suivi [�]
delai=38*10^-6;   %D�lai entre deux images d'une m�me paire [s]
vmax=30;    %Vitesse maximale dans le jet [m/s]
diam_max=1500; %diam�tre maximal estim� du spray [�m]

circ_inf=0.7;
circ_sup=1.5;
T1=.15;
T2=.05;
root='Test_Images/';
file=dir([root '*tif']);
for i=1:length(file)
    img{i}=file(i).name;
end

%Creation of the composite background
for n=1:25
    X(:,:,n)=(imread(strcat(root,img{(2*n)-1})));
    Y(:,:,n)=(imread(strcat(root,img{(2*n)})));
end
[x1,y1] = Background(X,Y);
clear X Y  
                        
         
h = waitbar(0,'Please wait...');       %Starting a waitbar
Droplet=[];
DropletRej=[];
for n=1:length(img)/2           
       waitbar(n / length(img)/2 ,h,['Image ' num2str(n) ' over ' num2str(length(img)/2)])        %Waitbar refreshing

        %Reading of the frames
        ImageA=img{(2*n)-1};
        ImageB=img{(2*n)};
        A=imread(strcat(root,ImageA));
        B=imread(strcat(root,ImageB));

        %Substraction of the background
        a=uint8(255*double(A)./double(x1));
        b=uint8(255*double(B)./double(y1));

        %Droplet Sizing
        [C1,D1,~,inf]=DropSizing(a,reso,circ_inf,circ_sup,T1);         
        [C2,D2]=DropSizing(b,reso,circ_inf,circ_sup,T2);
        n1(n)=length(D1);n2(n)=length(D2);
        
        %Droplet Tracking
        [g,gr]=Tracking(C1,D1,C2,D2,ImageA,reso,diff,angle,vmax,delai,inf);
    
        %Saving of the droplets
        Droplet=[Droplet g];  
        DropletRej=[DropletRej gr];
        
        %Some display of what the algorithm found
        if n<5
%             figure,imshow(a),hold on,plot(C1(:,1),C1(:,2),'*'),plot(C2(:,1),C2(:,2),'r*')
             Displacement(g,a)
        end


end
delete(h)  


%Drop size distribution


D=DropSizeDistribution(Droplet,delai,reso,500)
      

