#include "winsimpleclass.h"
#include "winexception.h"
#include "resstring.h"

WinSimpleClass::WinSimpleClass(const char *name, HINSTANCE hInst):
    _name(name), _hInstance(hInst)
{}

WinSimpleClass::WinSimpleClass(int resId, HINSTANCE hInst):
    _hInstance(hInst)
{
    ResString resStr(hInst, resId);
    _name = resStr;
}

WinSimpleClass::WinSimpleClass(const WinSimpleClass &rhs):
    _hInstance(rhs._hInstance), _name(rhs._name)
{}

WinSimpleClass::~WinSimpleClass()
{}

WinSimpleClass &WinSimpleClass::operator=(const WinSimpleClass &rhs)
{
    if(&rhs != this)
      {
      _hInstance = rhs._hInstance;
      _name = rhs._name;
      }
    return (*this);
}

char const* WinSimpleClass::GetName() const
{
    return _name.c_str();
}

HINSTANCE WinSimpleClass::GetInstance() const
{
    return _hInstance;
}

HWND WinSimpleClass::GetRunningWindow()
{
    HWND hwnd = ::FindWindow(GetName(), 0);
    
    if(::IsWindow(hwnd))
      {
      HWND hwndPopup = ::GetLastActivePopup(hwnd);
      
      if(::IsWindow(hwndPopup))
        hwnd = hwndPopup;
      }
    else hwnd = 0;
    
    return hwnd;  
}
