#ifndef WINMAKER_H
#define WINMAKER_H

#include <windows.h>
#include "winclass.h"

class WinMaker
{
protected:
    WinClass &_class;
    HWND _hwnd;
    DWORD _exStyle;             // extended window style
    char const *_windowName;    // pointer to window name
    DWORD _style;               // window style
    int _x;                     // horizontal position of window
    int _y;                     // vertical position of window
    int _width;                 // window width
    int _height;                // window height
    HWND _hWndParent;           // handle to parent or owner window
    HMENU _hMenu;               // handle to menu, or child-window ID
    void *_data;                // pointer to window-creation data
    
public:
    WinMaker(WinClass &winClass);
    WinMaker(const WinMaker &rhs);
    ~WinMaker();
    WinMaker &operator=(const WinMaker &rhs);
    operator HWND();
    void AddCaption(char const *caption);
    void AddSysMenu();
    void AddVScrollBar();
    void AddHScrollBar();
    void Create();
    void Show(int nCmdShow = SW_SHOWNORMAL);
};

#endif // WINMAKER_H
