#include "winmaker.h"
#include "winexception.h"
#include "ressources.h"

WinMaker::WinMaker(WinClass &winClass):
    _hwnd(0),
    _class(winClass),
    _exStyle(0),
    _windowName(0),
    _style(WS_OVERLAPPEDWINDOW),
    _x(CW_USEDEFAULT),
    _y(CW_USEDEFAULT),
    _width(CW_USEDEFAULT),
    _height(CW_USEDEFAULT),
    _hWndParent(HWND_DESKTOP),
    _hMenu(NULL),
    _data(NULL)
{}

WinMaker::WinMaker(const WinMaker &rhs): _class(rhs._class),
    _hwnd(rhs._hwnd),
    _exStyle(rhs._exStyle),
    _windowName(rhs._windowName),
    _style(rhs._style),
    _x(rhs._x),
    _y(rhs._y),
    _width(rhs._width),
    _height(rhs._height),
    _hWndParent(rhs._hWndParent),
    _hMenu(rhs._hMenu),
    _data(rhs._data)
{}

WinMaker &WinMaker::operator=(const WinMaker &rhs)
{
    if(&rhs != this)
      {
      _class = rhs._class;
      _hwnd = rhs._hwnd;
      _exStyle = rhs._exStyle;
      _windowName = rhs._windowName;
      _style = rhs._style;
      _x = rhs._x;
      _y = rhs._y;
      _width = rhs._width;
      _height = rhs._height;
      _hWndParent = rhs._hWndParent;
      _hMenu = rhs._hMenu;
      _data = rhs._data;
      }
    
    return (*this);
}

WinMaker::~WinMaker()
{}

WinMaker::operator HWND()
{
    return _hwnd;
}

void WinMaker::AddCaption(char const *caption)
{
    _windowName = caption;
}

void WinMaker::AddSysMenu()
{
    _style |= WS_SYSMENU;
}

void WinMaker::AddVScrollBar()
{
    _style |= WS_VSCROLL;
}

void WinMaker::AddHScrollBar()
{
    _style |= WS_HSCROLL;
}

void WinMaker::Create()
{    
    _hwnd = ::CreateWindowEx(
        _exStyle,
        _class.GetName(),
        _windowName,
        _style,
        _x,
        _y,
        _width,
        _height,
        _hWndParent,
        _hMenu,
        _class.GetInstance(),
        _data);
        
    if(_hwnd == 0)
      throw WinException("Erreur interne: la cration de la fentre a choue");

    _hMenu = ::LoadMenu(_class.GetInstance(), MAKEINTRESOURCE(MAINMENU));
    ::SetMenu(_hwnd, _hMenu);
}

void WinMaker::Show(int nCmdShow)
{
    ::ShowWindow(_hwnd, nCmdShow);
    ::UpdateWindow(_hwnd);
}
