#ifndef WINEXCEPTION_H
#define WINEXCEPTION_H

#include <windows.h>

// The exception class: stores the message and the error code
class WinException
{
private:
   DWORD _err;
   const char *_msg;
   int _error_param;

public:
   WinException(const char *msg, int error_param = 0);
   WinException(const WinException &rhs);
   ~WinException();
   WinException &operator=(const WinException &rhs);
   DWORD GetError() const;
   char const* GetMessage() const;
   int GetErrorParam() const;            
};

#endif // WINEXCEPTION_H
