#include "winexception.h"

WinException::WinException(const char *msg, int error_param):
    _err(::GetLastError()), _msg(msg), _error_param(error_param)
{}

WinException::WinException(const WinException &rhs):
    _err(rhs._err), _msg(rhs._msg), _error_param(rhs._error_param)
{}

WinException::~WinException()
{}

WinException &WinException::operator=(const WinException &rhs)
{
    if(&rhs != this)
      {
      _err = rhs._err;
      _msg = rhs._msg;
      _error_param = rhs._error_param;
      }
    return (*this);
}

DWORD WinException::GetError() const
{
    return _err;    
}

char const* WinException::GetMessage() const
{
    return _msg;
}

int WinException::GetErrorParam() const
{
    return _error_param;
}
