#include "winclass.h"
#include "winexception.h"
#include "ressources.h"

WinClass::WinClass(char const *className, HINSTANCE hInst,
    WNDPROC wndProc): WinSimpleClass(className, hInst)
{
    _class.lpfnWndProc = wndProc;
    SetDefaults();
}

WinClass::WinClass(int resId, HINSTANCE hInst, WNDPROC wndProc):
    WinSimpleClass(resId, hInst)
{
    _class.lpfnWndProc = wndProc;
    SetDefaults();
}

WinClass::WinClass(const WinClass &rhs): WinSimpleClass(rhs)
{
    _class.lpfnWndProc = rhs._class.lpfnWndProc;
    _class.hIcon = rhs._class.hIcon;
    _class.hIconSm = rhs._class.hIconSm;
    _class.hInstance = rhs._class.hInstance;
    _class.lpszClassName = rhs._class.lpszClassName;
    _class.style = rhs._class.style;
    _class.cbSize = rhs._class.cbSize;
    _class.hCursor = rhs._class.hCursor;
    _class.lpszMenuName = rhs._class.lpszMenuName;
    _class.cbClsExtra = rhs._class.cbClsExtra;
    _class.cbWndExtra = rhs._class.cbWndExtra;
    _class.hbrBackground = rhs._class.hbrBackground;
}

WinClass::~WinClass()
{}

WinClass &WinClass::operator=(const WinClass &rhs)
{
    if(&rhs != this)
      {
      _class.lpfnWndProc = rhs._class.lpfnWndProc;
      _class.hIcon = rhs._class.hIcon;
      _class.hIconSm = rhs._class.hIconSm;
      _class.hInstance = rhs._class.hInstance;
      _class.lpszClassName = rhs._class.lpszClassName;
      _class.style = rhs._class.style;
      _class.cbSize = rhs._class.cbSize;
      _class.hCursor = rhs._class.hCursor;
      _class.lpszMenuName = rhs._class.lpszMenuName;
      _class.cbClsExtra = rhs._class.cbClsExtra;
      _class.cbWndExtra = rhs._class.cbWndExtra;
      _class.hbrBackground = rhs._class.hbrBackground;
      }
    return (*this);
}

// Provide reasonable default values
void WinClass::SetDefaults()
{
    _class.hInstance = GetInstance();
    _class.lpszClassName = GetName();
    _class.style = CS_DBLCLKS;
    _class.cbSize = sizeof(WNDCLASSEX);
    
    SetResIcons(MY_ICON);
    
    _class.hCursor = ::LoadCursor(NULL, IDC_ARROW);
    _class.lpszMenuName = MAKEINTRESOURCE(MAINMENU);
    _class.cbClsExtra = 0;
    _class.cbWndExtra = 0;
    _class.hbrBackground = (HBRUSH) ::GetStockObject(LTGRAY_BRUSH);
}

void WinClass::SetBgSysColor(int sysColor)
{
    _class.hbrBackground = reinterpret_cast<HBRUSH> (sysColor+1);
}

void WinClass::SetResIcons(int resId)
{
    _class.hIcon = reinterpret_cast<HICON> (
        ::LoadImage(
        (HINSTANCE) _class.hInstance,
        MAKEINTRESOURCE(resId),
        IMAGE_ICON,
        ::GetSystemMetrics(SM_CXICON),
        ::GetSystemMetrics(SM_CYICON),
        0));
        
    // Small icon can beloaded from the same resource
    _class.hIconSm = reinterpret_cast<HICON> (
        ::LoadImage(
        (HINSTANCE) _class.hInstance,
        MAKEINTRESOURCE(resId),
        IMAGE_ICON,
        ::GetSystemMetrics(SM_CXSMICON),
        ::GetSystemMetrics(SM_CYSMICON),
        0));
}

void WinClass::Register()
{
    if(::RegisterClassEx(&_class) == 0)
        throw WinException("Erreur interne: chec de 'RegisterClassEx'");
}
