#ifndef VIEW_H
#define VIEW_H

#include <windows.h>
#include "canvas.h"
#include "model.h"

class View
{
protected:
    int _x, _y;
    HBITMAP _hbmp;
    
public:
    View(int x = 10, int y = 10);
    View(const View &rhs);
    ~View();
    View &operator=(const View &rhs);
    void SetSize(int x, int y);
    void GetSize(int &x, int &y);
    void Paint(Canvas &canvas, Model &model);
    void Update(Model &model);
    void Erase(Model &model);
};

#endif // VIEW_H
