#include "view.h"

#define ABS(a) (arg = (a), arg > 0 ? arg : -arg)

View::View(int x, int y): _x(x), _y(y),
    _hbmp(0)
{}

View::View(const View &rhs): _x(rhs._x), _y(rhs._y),
    _hbmp(rhs._hbmp)
{}

View::~View()
{}

View &View::operator=(const View &rhs)
{
    if(&rhs != this)
      {
      _x = rhs._x;
      _y = rhs._y;
      _hbmp = rhs._hbmp;
      }
    return (*this);
}

void View::SetSize(int x, int y)
{
    _x = x;
    _y = y;
}

void View::GetSize(int &x, int &y)
{
    x = _x;
    y = _y;
}

void View::Paint(Canvas &canvas, Model &model)
{
    canvas.Paint(model.GetBmp(), _x, _y);
}

void View::Update(Model &model)
{
    HDC hdc = GetDC(model); // Implicit cast
    _hbmp = CreateCompatibleBitmap(hdc, model.GetBmp()->Height,
            model.GetBmp()->Width);
    GetObject(_hbmp, sizeof(model.GetBmp()), (void*)model.GetBmp());
    
    HDC hdcMemory;
    hdcMemory = CreateCompatibleDC(hdc);
    SelectObject(hdcMemory, _hbmp);
    
    model.GetBmp()->GDIPaint(hdc, _x, _y);
    
    DeleteDC(hdcMemory);
    ReleaseDC(model, hdc); // Implicit cas
    DeleteDC(hdc);
}

void View::Erase(Model &model)
{
    static int arg;
    
    RECT rc;
    rc.left = _x;
    rc.top = _y;
    rc.right = _x + ABS(model.GetBmp()->Width);
    rc.bottom = _y + ABS(model.GetBmp()->Height);
    
    HDC hdc = GetDC(model); // Implicit cast
    FillRect(hdc, &rc, (HBRUSH)GetStockObject(LTGRAY_BRUSH));
    
    ReleaseDC(model, hdc);  // Implicit cast
    DeleteDC(hdc);
}
