#include "resstring.h"
#include "winexception.h"
#include <string.h>

ResString::ResString(int resId)
{
    if(! ::LoadString((HINSTANCE) ::GetModuleHandle(0), resId, _buf, MAX_RESSTRING+1))
      throw WinException("Le chargement des ressources chanes de caractres a chou");
}

ResString::ResString(HINSTANCE hInst, int resId)
{
    if(! ::LoadString(hInst, resId, _buf, MAX_RESSTRING+1))
      throw WinException("Le chargement des ressources chanes de caractres a chou");
}

ResString::ResString(const ResString &rhs)
{
    memcpy(_buf, rhs._buf, MAX_RESSTRING+1);
}

ResString::~ResString()
{}

ResString &ResString::operator=(const ResString &rhs)
{
    if(&rhs != this)
      memcpy(_buf, rhs._buf, MAX_RESSTRING+1);
    return (*this);
}

ResString::operator char const*()
{
    return _buf;
}

