#ifndef RESSOURCES_H
#define RESSOURCES_H

#include "config.h"

#define ID_MAIN     1
#define ID_CAPTION  2

#define ID_CAPTION_TEXT 10
#define ID_ABOUT_TEXT   11
#define ID_ABOUT_TITLE  12
#define MY_ICON_PATH    13

// Icon
#define MY_ICON         500
#define MAINMENU        501

// Menu
#define ID_FILE_OPEN    9000
#define ID_FILE_SAVEAS  9001
#define ID_FILE_EXPORT  9002
#define ID_FILE_CLOSE   9003
#define ID_FILE_EXIT    9004

#define ID_DIFFRACT_DIFFRACT     8000
#define ID_DIFFRACT_RELOAD       8001
#define ID_DIFFRACT_DEFPARAMS    8002

#define ID_COLORMAP_PINK    7000
#define ID_COLORMAP_HOT     7001
#define ID_COLORMAP_JET     7002
#define ID_COLORMAP_HSV     7003
#define ID_COLORMAP_GRAY    7004
#define ID_COLORMAP_GRAYINV 7005

#define ID_ABOUT        6000

// ColorMap identifiers
#define ID_NO_MAP        20
#define ID_MAP_PINK      21
#define ID_MAP_HOT       22
#define ID_MAP_JET       23
#define ID_MAP_HSV       24
#define ID_MAP_GRAY      25
#define ID_MAP_GRAYINV   26

// Regroup the identifiers for the error messages
#define ERROR_UNKNOWN_COMMAND   100
#define ERROR_READING_FILE      101
#define ERROR_SAVING_FILE       102
#define ERROR_EXPORTING_DATA    103
#define ERROR_RELOAD_FILE       104
#define ERROR_NO_FILE_OPEN      105
#define ERROR_DIFFRACT_DONE     106
#define ERROR_NO_FILE_TO_SAVE   107
#define ERROR_NO_DATA_TO_EXPORT 108
#define ERROR_PLEASE_OPEN_FILE  109
#define ERROR_MEMORY_ALLOC      110
#define ERROR_MEMORY_REALLOC    111
#define ERROR_FOURIER_INIT      112
#define ERROR_FOURIER_SIZE      113
#define ERROR_FILE_NO_BITMAP    114
#define ERROR_SCALE_WIDTH       115
#define ERROR_RESTORING_PARAMS  116
#define ERROR_FILE_PARAMS       117
#define ERROR_NO_FILE_PARAMS    118
#define ERROR_UNKNOWN_ERROR     119

//
// Default parameters
//

// Identifier to the name of the default parameters file
#define DEFAULT_PARAM_NAME 10000

// Number of different parameters
#define NB_PARAMETERS 6

// pi
#define M_PI 3.141592653589793

// A small positive number
#define TINY 1.0e-15

// [m] Wavelength of the incidente plane wave
#define LAMBDA_WAVE 0.1

// [m] Distance from aperture to screen
#define SCREEN_DISTANCE 10

// [m] Spatial step in the x direction
#define DX_STEP 1.0e-5

// [m] Spatial step in the y direction
#define DY_STEP 1.0e-5

#endif // RESSOURCES_H
