#ifndef MY_PARAMETERS_H
#define MY_PARAMETERS_H

#include <windows.h>
#include <string>

class Parameters
{
private:
    std::string _name;
    double _pi;
    double _tiny;
    double _lambda;
    double _screenDistance;
    double _dxStep;
    double _dyStep;
    int _nbParameters;
    
    void Process();
    double ProcessString(char const *pc);
    
public:
    Parameters();
    Parameters(const std::string &name);
    Parameters(const Parameters &rhs);
    ~Parameters();
    Parameters &operator=(const Parameters &rhs);
    void RestoreDefaults();
    void ReloadParams();
    double pi() const;
    double tiny() const;
    double lambda() const;
    double screenDistance() const;
    double dxStep() const;
    double dyStep() const;
    char const* name() const;
};

#endif // MY_PARAMETERS_H
