#include "paintcanvas.h"

PaintCanvas::PaintCanvas(HWND hwnd):
    Canvas(::BeginPaint(hwnd, &_paint)),
    _hwnd(hwnd)
{}

PaintCanvas::PaintCanvas(const PaintCanvas &rhs):
    Canvas(rhs), _hwnd(rhs._hwnd)
{
    _paint.hdc = rhs._paint.hdc;
    _paint.fErase = rhs._paint.fErase;
    _paint.rcPaint.left = rhs._paint.rcPaint.left;
    _paint.rcPaint.top = rhs._paint.rcPaint.top;
    _paint.rcPaint.right = rhs._paint.rcPaint.right;
    _paint.rcPaint.bottom = rhs._paint.rcPaint.bottom;
    _paint.fRestore = rhs._paint.fRestore;
    _paint.fIncUpdate = rhs._paint.fIncUpdate;

    for(int i = 0; i < 32; i++)
       _paint.rgbReserved[i] = rhs._paint.rgbReserved[i];
}

PaintCanvas::~PaintCanvas()
{
    ::EndPaint(_hwnd, &_paint);
}

PaintCanvas &PaintCanvas::operator=(const PaintCanvas &rhs)
{
    if(&rhs != this)
      {
      _hwnd = rhs._hwnd;

      _paint.hdc = rhs._paint.hdc;
      _paint.fErase = rhs._paint.fErase;
      _paint.rcPaint.left = rhs._paint.rcPaint.left;
      _paint.rcPaint.top = rhs._paint.rcPaint.top;
      _paint.rcPaint.right = rhs._paint.rcPaint.right;
      _paint.rcPaint.bottom = rhs._paint.rcPaint.bottom;
      _paint.fRestore = rhs._paint.fRestore;
      _paint.fIncUpdate = rhs._paint.fIncUpdate;
  
      for(int i = 0; i < 32; i++)
          _paint.rgbReserved[i] = rhs._paint.rgbReserved[i];
      }
    return (*this);
}
