#include "model.h"
#include "config.h"
#include <math.h>
#include <fstream>

Model::Model(HWND hwnd, CRaster *bmp, ColorMap *cmap):
    Diffraction(hwnd, bmp, cmap)
{}

Model::Model(const Model &rhs): Diffraction(rhs)
{}

Model::~Model()
{}

Model &Model::operator=(const Model &rhs)
{
    return (*this);
}

CRaster const* Model::GetBmp() const
{
    return _bmp;
}

// Export "_dataAbs" to a data file
int Model::Export(const char *filename) const
{
    if(_dataAbs != NULL)
      {
      unsigned int m, n, width(_bmp->Width), height((int)fabs(_bmp->Height));
      double max = (_dataMax != 0.0 ? _dataMax : 1.0);
      std::ofstream file;
      file.open(filename, std::ios::out);
    
      if(!file.is_open()) return FAIL;

      for(n = 0; n < height; n++)
         {
         for(m = 0; m < width; m++)
            file << _dataAbs[n*width+m]/max << "\t";
            
        file << "\n";    
        }
    
      file.close();
      }
    else return FAIL;
    
return SUCCESS;    
}
