/* Diffraction par un diaphragme d'une onde plane.

 Approximation de Fraunhofer.
 Valide pour une distance z "trs longue".
 (Approximation paraxiale  longue distance en regard de la longueur
 d'onde).

 Leblanc Christophe.
 UCL, Dcembre 2011.
 cleblancad@gmail.com

 Licence:

 Toute utilisation, modification et exploitation de ce code est permis
 dans le cadre d'un but non-commercial sous rserve de citer le nom de
 l'auteur (Leblanc Christophe), la rfrence et d'inclure la prsente licence non-amende.

 L'auteur de ce code dcline toute responsabilit en cas de mauvaise utilisation
 de celui-ci et le fournit sans aucune garantie quant  sa fiabilit.

 Ce code et le programme qui l'accompagne

 Voir la licence accompagnant ce code pour plus de dtails.
 Si aucune licence n'accompagne ce code
 vous tes en prsence d'une copie illgale.

 Merci alors de signaler  l'adresse mail renseigne ci-dessus
 o, quand, comment et par qui cette copie illgale vous a t fournie.*/

#include "maininclude.h"

/* Declare Windows procedure */
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);

int WINAPI WinMain(HINSTANCE hThisInstance, HINSTANCE hPrevInstance, LPSTR lpszArgument, int cmdShow)
{
try
  {
  // Using exceptions here helps debugging the program
  TopWinClass winClass(ID_MAIN, hThisInstance, WindowProcedure);
  winClass.Register();
  
  // Create window
  TopWinMaker win(winClass, ID_CAPTION_TEXT);
  win.Create();
  win.Show();
  
  MSG messages; // Here messages to the application are saved
  int status;
  
  // Run the message loop. It will run until GetMessage( ) returns 0
  while((status = ::GetMessage(&messages, NULL, 0, 0)) != 0)
     {
     if(status == -1) return FAIL;
     
     ::TranslateMessage(&messages);
     ::DispatchMessage(&messages);
     }
  
  // The program return-value is 0 - The value that PostQuitMessage( ) gave   
  return messages.wParam;
  }
catch(WinException &e)
  {
  char buf[1024];
  wsprintf(buf, "%s, Erreur %d", e.GetMessage(), e.GetError());
  ::MessageBox(0, buf, "Erreur", MB_ICONEXCLAMATION | MB_OK);

  return FAIL;
  }  
catch(...)
  {
  ::MessageBox(0, "Inconnue", "Erreur", MB_ICONEXCLAMATION | MB_OK);
  return FAIL;
  }   

return SUCCESS;      
}

/* This function is called by the Windows function DispatchMessage( ) */
LRESULT CALLBACK WindowProcedure(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
Controller *pCtrl = WinGetLong<Controller *>(hwnd);
    
    // Have to catch exception in case new throws!
    switch(message)
       {
       case WM_CREATE:
            TRYCATCH_BLOCK2(pCtrl = new Controller(hwnd, ID_MAP_HOT),
                WinSetLong<Controller*>(hwnd, pCtrl),
                "Initialisation");
       break;
       
       case WM_COMMAND:
            TRYCATCH_BLOCK1(pCtrl->Command(hwnd, wParam, lParam),
                "Commande illgale");
       break;
       
       case WM_PAINT:
            TRYCATCH_BLOCK1(pCtrl->Paint(), "Affichage");
       break;
       
       case WM_DESTROY: {
            if(pCtrl->CloseProc() != SUCCESS) return FAIL;
            WinSetLong<Controller*> (hwnd, 0);
            delete pCtrl;
            ::PostQuitMessage(0);
            }
       break;
       
       default:
            return ::DefWindowProc(hwnd, message, wParam, lParam);
       }
       
return SUCCESS;       
}
