// *************************************************************
//                       BMP LOAD EXAMPLE
//         Written by Juan Soulie <jsoulie@cplusplus.com>
//
// Copyright  2000, Juan Soulie jsoulie@cplusplus.com
// Permission to use, copy, modify, distribute and sell
// this software or any part thereof and/or its documentation
// for any purpose is granted without fee provided that
// the above copyright notice and this permission notice
// appear in all copies.
//
// This software is provided "as is" without express or implied warranty of any kind. The author shall have no liability with respect to the infringement of copyrights or patents that any modification to the content of this file or this file itself may incur.
//
//
//  Improved by Leblanc Christophe (new functions).
//  January 2011.
// *************************************************************

#ifndef LOADBMP_H
#define LOADBMP_H

#include <windows.h>

// class CRaster
//   - Generic class for BMP raster images.
class CRaster
{
public:
    int Width, Height;      // Dimensions.
    int BPP;                // Bits Per Pixel.
    char *Raster;           // Bits of the image.
    RGBQUAD *Palette;       // RGB Palette for the image.
    int BytesPerRow;        // Row width (in bytes).
    BITMAPINFO *pbmi;       // BITMAPINFO structure.
    BITMAPFILEHEADER bmfh;  // BITMAPHEADER structure.
    bool _resized;          // True if the image is resized.
    
// Member functions
CRaster();
~CRaster();
CRaster(const CRaster &rhs);
CRaster &operator=(const CRaster &rhs);
int LoadBMP(HWND hwnd, const char *szFile);
int SaveBMP(HWND hwnd, const char *szFile);
int ResizeBMP(int newWidth, int newHeight);
void EraseBMP();
int GDIPaint(HDC hdc, int x = 0, int y = 0) const;          
};

#endif // LOADBMP_H
