#ifndef DIFFRACTIONCONTROL_H
#define DIFFRACTIONCONTROL_H

#include <windows.h>
#include <string>
#include "simplecontrol.h"
#include "model.h"
#include "view.h"
#include "loadbmp.h"
#include "colormap.h"
#include "parameters.h"

class DiffractionControl: public SimpleControl
{
private:
    Model *_model;
    View _view;
    CRaster *_bmp;
    ColorMap _cmap;
    Parameters *_params;
    BOOL fileOpen, fileSaved, alreadyDiffract;
    std::string lastFileOpen;
    
    BOOL OpenFile();
    BOOL SaveFile();
    BOOL ExportFile() const;
    void OpenFileProc();
    void CloseFileProc();
    void ReloadFileProc();
    int DiffractionProc();
    void SaveAsFileProc();
    void ExportFileProc();
    void SetMapProc(int IDmap);
    
public:
    DiffractionControl(HWND hwnd, int id, int IDmap);
    ~DiffractionControl();
    int CloseProc();
    operator HWND () const;
    void Size(int x, int y);
    void Paint();
    void Command(int cmd);
};

#endif // DIFFRACTIONCONTROL_H
